// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.model



/**
 * A representation of a billing group.
 */
class BillingGroupListElement private constructor(builder: Builder) {
    /**
     * The Amazon Resource Number (ARN) that can be used to uniquely identify the billing group.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group.
     */
    val computationPreference: aws.sdk.kotlin.services.billingconductor.model.ComputationPreference? = builder.computationPreference
    /**
     * The time the billing group was created.
     */
    val creationTime: kotlin.Long = builder.creationTime
    /**
     * The billing group description.
     */
    val description: kotlin.String? = builder.description
    /**
     * The most recent time the billing group was modified.
     */
    val lastModifiedTime: kotlin.Long = builder.lastModifiedTime
    /**
     * The billing group's name.
     */
    val name: kotlin.String? = builder.name
    /**
     * The account ID that serves as the main account in a billing group.
     */
    val primaryAccountId: kotlin.String? = builder.primaryAccountId
    /**
     * The number of accounts in the particular billing group.
     */
    val size: kotlin.Long = builder.size
    /**
     * The billing group status. Only one of the valid values can be used.
     */
    val status: aws.sdk.kotlin.services.billingconductor.model.BillingGroupStatus? = builder.status
    /**
     * The reason why the billing group is in its current status.
     */
    val statusReason: kotlin.String? = builder.statusReason

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.billingconductor.model.BillingGroupListElement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BillingGroupListElement(")
        append("arn=$arn,")
        append("computationPreference=$computationPreference,")
        append("creationTime=$creationTime,")
        append("description=*** Sensitive Data Redacted ***,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=*** Sensitive Data Redacted ***,")
        append("primaryAccountId=$primaryAccountId,")
        append("size=$size,")
        append("status=$status,")
        append("statusReason=$statusReason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (computationPreference?.hashCode() ?: 0)
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (primaryAccountId?.hashCode() ?: 0)
        result = 31 * result + (size.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BillingGroupListElement

        if (arn != other.arn) return false
        if (computationPreference != other.computationPreference) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (primaryAccountId != other.primaryAccountId) return false
        if (size != other.size) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.billingconductor.model.BillingGroupListElement = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Number (ARN) that can be used to uniquely identify the billing group.
         */
        var arn: kotlin.String? = null
        /**
         * The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group.
         */
        var computationPreference: aws.sdk.kotlin.services.billingconductor.model.ComputationPreference? = null
        /**
         * The time the billing group was created.
         */
        var creationTime: kotlin.Long = 0L
        /**
         * The billing group description.
         */
        var description: kotlin.String? = null
        /**
         * The most recent time the billing group was modified.
         */
        var lastModifiedTime: kotlin.Long = 0L
        /**
         * The billing group's name.
         */
        var name: kotlin.String? = null
        /**
         * The account ID that serves as the main account in a billing group.
         */
        var primaryAccountId: kotlin.String? = null
        /**
         * The number of accounts in the particular billing group.
         */
        var size: kotlin.Long = 0L
        /**
         * The billing group status. Only one of the valid values can be used.
         */
        var status: aws.sdk.kotlin.services.billingconductor.model.BillingGroupStatus? = null
        /**
         * The reason why the billing group is in its current status.
         */
        var statusReason: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.billingconductor.model.BillingGroupListElement) : this() {
            this.arn = x.arn
            this.computationPreference = x.computationPreference
            this.creationTime = x.creationTime
            this.description = x.description
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.primaryAccountId = x.primaryAccountId
            this.size = x.size
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.billingconductor.model.BillingGroupListElement = BillingGroupListElement(this)

        /**
         * construct an [aws.sdk.kotlin.services.billingconductor.model.ComputationPreference] inside the given [block]
         */
        fun computationPreference(block: aws.sdk.kotlin.services.billingconductor.model.ComputationPreference.Builder.() -> kotlin.Unit) {
            this.computationPreference = aws.sdk.kotlin.services.billingconductor.model.ComputationPreference.invoke(block)
        }
    }
}
