// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.billingconductor.model.*
import aws.sdk.kotlin.services.billingconductor.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "billingconductor"
const val ServiceApiVersion: String = "2021-07-30"
const val SdkVersion: String = "0.16.0"

internal class DefaultBillingconductorClient(override val config: BillingconductorClient.Config) : BillingconductorClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Connects an array of account IDs in a consolidated billing family to a predefined billing group. The account IDs must be a part of the consolidated billing family during the current month, and not already associated with another billing group. The maximum number of accounts that can be associated in one call is 30.
     */
    override suspend fun associateAccounts(input: AssociateAccountsRequest): AssociateAccountsResponse {
        val op = SdkHttpOperation.build<AssociateAccountsRequest, AssociateAccountsResponse> {
            serializer = AssociateAccountsOperationSerializer()
            deserializer = AssociateAccountsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateAccounts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Connects an array of `PricingRuleArns` to a defined `PricingPlan`. The maximum number `PricingRuleArn` that can be associated in one call is 30.
     */
    override suspend fun associatePricingRules(input: AssociatePricingRulesRequest): AssociatePricingRulesResponse {
        val op = SdkHttpOperation.build<AssociatePricingRulesRequest, AssociatePricingRulesResponse> {
            serializer = AssociatePricingRulesOperationSerializer()
            deserializer = AssociatePricingRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociatePricingRules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a batch of resources to a percentage custom line item.
     */
    override suspend fun batchAssociateResourcesToCustomLineItem(input: BatchAssociateResourcesToCustomLineItemRequest): BatchAssociateResourcesToCustomLineItemResponse {
        val op = SdkHttpOperation.build<BatchAssociateResourcesToCustomLineItemRequest, BatchAssociateResourcesToCustomLineItemResponse> {
            serializer = BatchAssociateResourcesToCustomLineItemOperationSerializer()
            deserializer = BatchAssociateResourcesToCustomLineItemOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchAssociateResourcesToCustomLineItem"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a batch of resources from a percentage custom line item.
     */
    override suspend fun batchDisassociateResourcesFromCustomLineItem(input: BatchDisassociateResourcesFromCustomLineItemRequest): BatchDisassociateResourcesFromCustomLineItemResponse {
        val op = SdkHttpOperation.build<BatchDisassociateResourcesFromCustomLineItemRequest, BatchDisassociateResourcesFromCustomLineItemResponse> {
            serializer = BatchDisassociateResourcesFromCustomLineItemOperationSerializer()
            deserializer = BatchDisassociateResourcesFromCustomLineItemOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDisassociateResourcesFromCustomLineItem"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a billing group that resembles a consolidated billing family that Amazon Web Services charges, based off of the predefined pricing plan computation.
     */
    override suspend fun createBillingGroup(input: CreateBillingGroupRequest): CreateBillingGroupResponse {
        val op = SdkHttpOperation.build<CreateBillingGroupRequest, CreateBillingGroupResponse> {
            serializer = CreateBillingGroupOperationSerializer()
            deserializer = CreateBillingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBillingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a custom line item that can be used to create a one-time fixed charge that can be applied to a single billing group for the current or previous billing period. The one-time fixed charge is either a fee or discount.
     */
    override suspend fun createCustomLineItem(input: CreateCustomLineItemRequest): CreateCustomLineItemResponse {
        val op = SdkHttpOperation.build<CreateCustomLineItemRequest, CreateCustomLineItemResponse> {
            serializer = CreateCustomLineItemOperationSerializer()
            deserializer = CreateCustomLineItemOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCustomLineItem"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a pricing plan that is used for computing Amazon Web Services charges for billing groups.
     */
    override suspend fun createPricingPlan(input: CreatePricingPlanRequest): CreatePricingPlanResponse {
        val op = SdkHttpOperation.build<CreatePricingPlanRequest, CreatePricingPlanResponse> {
            serializer = CreatePricingPlanOperationSerializer()
            deserializer = CreatePricingPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePricingPlan"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a pricing rule can be associated to a pricing plan, or a set of pricing plans.
     */
    override suspend fun createPricingRule(input: CreatePricingRuleRequest): CreatePricingRuleResponse {
        val op = SdkHttpOperation.build<CreatePricingRuleRequest, CreatePricingRuleResponse> {
            serializer = CreatePricingRuleOperationSerializer()
            deserializer = CreatePricingRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePricingRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a billing group.
     */
    override suspend fun deleteBillingGroup(input: DeleteBillingGroupRequest): DeleteBillingGroupResponse {
        val op = SdkHttpOperation.build<DeleteBillingGroupRequest, DeleteBillingGroupResponse> {
            serializer = DeleteBillingGroupOperationSerializer()
            deserializer = DeleteBillingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBillingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the custom line item identified by the given ARN in the current, or previous billing period.
     */
    override suspend fun deleteCustomLineItem(input: DeleteCustomLineItemRequest): DeleteCustomLineItemResponse {
        val op = SdkHttpOperation.build<DeleteCustomLineItemRequest, DeleteCustomLineItemResponse> {
            serializer = DeleteCustomLineItemOperationSerializer()
            deserializer = DeleteCustomLineItemOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCustomLineItem"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a pricing plan. The pricing plan must not be associated with any billing groups to delete successfully.
     */
    override suspend fun deletePricingPlan(input: DeletePricingPlanRequest): DeletePricingPlanResponse {
        val op = SdkHttpOperation.build<DeletePricingPlanRequest, DeletePricingPlanResponse> {
            serializer = DeletePricingPlanOperationSerializer()
            deserializer = DeletePricingPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePricingPlan"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the pricing rule identified by the input Amazon Resource Name (ARN).
     */
    override suspend fun deletePricingRule(input: DeletePricingRuleRequest): DeletePricingRuleResponse {
        val op = SdkHttpOperation.build<DeletePricingRuleRequest, DeletePricingRuleResponse> {
            serializer = DeletePricingRuleOperationSerializer()
            deserializer = DeletePricingRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePricingRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified list of account IDs from the given billing group.
     */
    override suspend fun disassociateAccounts(input: DisassociateAccountsRequest): DisassociateAccountsResponse {
        val op = SdkHttpOperation.build<DisassociateAccountsRequest, DisassociateAccountsResponse> {
            serializer = DisassociateAccountsOperationSerializer()
            deserializer = DisassociateAccountsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateAccounts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a list of pricing rules from a pricing plan.
     */
    override suspend fun disassociatePricingRules(input: DisassociatePricingRulesRequest): DisassociatePricingRulesResponse {
        val op = SdkHttpOperation.build<DisassociatePricingRulesRequest, DisassociatePricingRulesResponse> {
            serializer = DisassociatePricingRulesOperationSerializer()
            deserializer = DisassociatePricingRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociatePricingRules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * ***Amazon Web Services Billing Conductor is in beta release and is subject to change. Your use of Amazon Web Services Billing Conductor is subject to the Beta Service Participation terms of the [Amazon Web Services Service Terms](https://aws.amazon.com/service-terms/) (Section 1.10).***
     *
     *  This is a paginated call to list linked accounts that are linked to the payer account for the specified time period. If no information is provided, the current billing period is used. The response will optionally include the billing group associated with the linked account.
     */
    override suspend fun listAccountAssociations(input: ListAccountAssociationsRequest): ListAccountAssociationsResponse {
        val op = SdkHttpOperation.build<ListAccountAssociationsRequest, ListAccountAssociationsResponse> {
            serializer = ListAccountAssociationsOperationSerializer()
            deserializer = ListAccountAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccountAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web Services charges based on the associated pricing plan of a billing group.
     */
    override suspend fun listBillingGroupCostReports(input: ListBillingGroupCostReportsRequest): ListBillingGroupCostReportsResponse {
        val op = SdkHttpOperation.build<ListBillingGroupCostReportsRequest, ListBillingGroupCostReportsResponse> {
            serializer = ListBillingGroupCostReportsOperationSerializer()
            deserializer = ListBillingGroupCostReportsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBillingGroupCostReports"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a billing group, the current billing period is used.
     */
    override suspend fun listBillingGroups(input: ListBillingGroupsRequest): ListBillingGroupsResponse {
        val op = SdkHttpOperation.build<ListBillingGroupsRequest, ListBillingGroupsResponse> {
            serializer = ListBillingGroupsOperationSerializer()
            deserializer = ListBillingGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBillingGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't provide a billing period, the current billing period is used.
     */
    override suspend fun listCustomLineItems(input: ListCustomLineItemsRequest): ListCustomLineItemsResponse {
        val op = SdkHttpOperation.build<ListCustomLineItemsRequest, ListCustomLineItemsResponse> {
            serializer = ListCustomLineItemsOperationSerializer()
            deserializer = ListCustomLineItemsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCustomLineItems"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the current billing period is used.
     */
    override suspend fun listPricingPlans(input: ListPricingPlansRequest): ListPricingPlansResponse {
        val op = SdkHttpOperation.build<ListPricingPlansRequest, ListPricingPlansResponse> {
            serializer = ListPricingPlansOperationSerializer()
            deserializer = ListPricingPlansOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPricingPlans"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A list of the pricing plans associated with a pricing rule.
     */
    override suspend fun listPricingPlansAssociatedWithPricingRule(input: ListPricingPlansAssociatedWithPricingRuleRequest): ListPricingPlansAssociatedWithPricingRuleResponse {
        val op = SdkHttpOperation.build<ListPricingPlansAssociatedWithPricingRuleRequest, ListPricingPlansAssociatedWithPricingRuleResponse> {
            serializer = ListPricingPlansAssociatedWithPricingRuleOperationSerializer()
            deserializer = ListPricingPlansAssociatedWithPricingRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPricingPlansAssociatedWithPricingRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
     */
    override suspend fun listPricingRules(input: ListPricingRulesRequest): ListPricingRulesResponse {
        val op = SdkHttpOperation.build<ListPricingRulesRequest, ListPricingRulesResponse> {
            serializer = ListPricingRulesOperationSerializer()
            deserializer = ListPricingRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPricingRules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the pricing rules associated with a pricing plan.
     */
    override suspend fun listPricingRulesAssociatedToPricingPlan(input: ListPricingRulesAssociatedToPricingPlanRequest): ListPricingRulesAssociatedToPricingPlanResponse {
        val op = SdkHttpOperation.build<ListPricingRulesAssociatedToPricingPlanRequest, ListPricingRulesAssociatedToPricingPlanResponse> {
            serializer = ListPricingRulesAssociatedToPricingPlanOperationSerializer()
            deserializer = ListPricingRulesAssociatedToPricingPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPricingRulesAssociatedToPricingPlan"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the resources associated to a custom line item.
     */
    override suspend fun listResourcesAssociatedToCustomLineItem(input: ListResourcesAssociatedToCustomLineItemRequest): ListResourcesAssociatedToCustomLineItemResponse {
        val op = SdkHttpOperation.build<ListResourcesAssociatedToCustomLineItemRequest, ListResourcesAssociatedToCustomLineItemResponse> {
            serializer = ListResourcesAssociatedToCustomLineItemOperationSerializer()
            deserializer = ListResourcesAssociatedToCustomLineItemOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListResourcesAssociatedToCustomLineItem"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A list the tags for a resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes specified tags from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This updates an existing billing group.
     */
    override suspend fun updateBillingGroup(input: UpdateBillingGroupRequest): UpdateBillingGroupResponse {
        val op = SdkHttpOperation.build<UpdateBillingGroupRequest, UpdateBillingGroupResponse> {
            serializer = UpdateBillingGroupOperationSerializer()
            deserializer = UpdateBillingGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBillingGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update an existing custom line item in the current or previous billing period.
     */
    override suspend fun updateCustomLineItem(input: UpdateCustomLineItemRequest): UpdateCustomLineItemResponse {
        val op = SdkHttpOperation.build<UpdateCustomLineItemRequest, UpdateCustomLineItemResponse> {
            serializer = UpdateCustomLineItemOperationSerializer()
            deserializer = UpdateCustomLineItemOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCustomLineItem"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This updates an existing pricing plan.
     */
    override suspend fun updatePricingPlan(input: UpdatePricingPlanRequest): UpdatePricingPlanResponse {
        val op = SdkHttpOperation.build<UpdatePricingPlanRequest, UpdatePricingPlanResponse> {
            serializer = UpdatePricingPlanOperationSerializer()
            deserializer = UpdatePricingPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePricingPlan"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing pricing rule.
     */
    override suspend fun updatePricingRule(input: UpdatePricingRuleRequest): UpdatePricingRuleResponse {
        val op = SdkHttpOperation.build<UpdatePricingRuleRequest, UpdatePricingRuleResponse> {
            serializer = UpdatePricingRuleOperationSerializer()
            deserializer = UpdatePricingRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePricingRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "billingconductor"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "billingconductor")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
