// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.billingconductor.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.billingconductor.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.crt.CrtAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Web Services Billing Conductor is a fully managed service that you can use to customize a [pro forma](https://docs.aws.amazon.com/enterprisebilling/6b7c01c5-b592-467e-9769-90052eaf359c/userguide/understanding-eb.html#eb-other-definitions) version of your billing data each month, to accurately show or chargeback your end customers. Amazon Web Services Billing Conductor doesn't change the way you're billed by Amazon Web Services each month by design. Instead, it provides you with a mechanism to configure, generate, and display rates to certain customers over a given billing period. You can also analyze the difference between the rates you apply to your accounting groupings relative to your actual rates from Amazon Web Services. As a result of your Amazon Web Services Billing Conductor configuration, the payer account can also see the custom rate applied on the billing details page of the [Amazon Web Services Billing console](https://console.aws.amazon.com/billing), or configure a cost and usage report per billing group.
 *
 * This documentation shows how you can configure Amazon Web Services Billing Conductor using its API. For more information about using the [Amazon Web Services Billing Conductor](https://console.aws.amazon.com/enterprisebilling/) user interface, see the [ Amazon Web Services Enterprise Billing Console User Guide](https://docs.aws.amazon.com/enterprisebilling/6b7c01c5-b592-467e-9769-90052eaf359c/userguide/what-is-enterprisebilling.html).
 */
interface BillingconductorClient : SdkClient {

    override val serviceName: String
        get() = "billingconductor"
    /**
     * BillingconductorClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): BillingconductorClient {
            val config = Config.Builder().apply(block).build()
            return DefaultBillingconductorClient(config)
        }

        operator fun invoke(config: Config): BillingconductorClient = DefaultBillingconductorClient(config)

        /**
         * Construct a [BillingconductorClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): BillingconductorClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultBillingconductorClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: CrtAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Connects an array of account IDs in a consolidated billing family to a predefined billing group. The account IDs must be a part of the consolidated billing family during the current month, and not already associated with another billing group. The maximum number of accounts that can be associated in one call is 30.
     */
    suspend fun associateAccounts(input: AssociateAccountsRequest): AssociateAccountsResponse

    /**
     * Connects an array of account IDs in a consolidated billing family to a predefined billing group. The account IDs must be a part of the consolidated billing family during the current month, and not already associated with another billing group. The maximum number of accounts that can be associated in one call is 30.
     */
    suspend fun associateAccounts(block: AssociateAccountsRequest.Builder.() -> Unit) = associateAccounts(AssociateAccountsRequest.Builder().apply(block).build())

    /**
     * Connects an array of `PricingRuleArns` to a defined `PricingPlan`. The maximum number `PricingRuleArn` that can be associated in one call is 30.
     */
    suspend fun associatePricingRules(input: AssociatePricingRulesRequest): AssociatePricingRulesResponse

    /**
     * Connects an array of `PricingRuleArns` to a defined `PricingPlan`. The maximum number `PricingRuleArn` that can be associated in one call is 30.
     */
    suspend fun associatePricingRules(block: AssociatePricingRulesRequest.Builder.() -> Unit) = associatePricingRules(AssociatePricingRulesRequest.Builder().apply(block).build())

    /**
     * Associates a batch of resources to a percentage custom line item.
     */
    suspend fun batchAssociateResourcesToCustomLineItem(input: BatchAssociateResourcesToCustomLineItemRequest): BatchAssociateResourcesToCustomLineItemResponse

    /**
     * Associates a batch of resources to a percentage custom line item.
     */
    suspend fun batchAssociateResourcesToCustomLineItem(block: BatchAssociateResourcesToCustomLineItemRequest.Builder.() -> Unit) = batchAssociateResourcesToCustomLineItem(BatchAssociateResourcesToCustomLineItemRequest.Builder().apply(block).build())

    /**
     * Disassociates a batch of resources from a percentage custom line item.
     */
    suspend fun batchDisassociateResourcesFromCustomLineItem(input: BatchDisassociateResourcesFromCustomLineItemRequest): BatchDisassociateResourcesFromCustomLineItemResponse

    /**
     * Disassociates a batch of resources from a percentage custom line item.
     */
    suspend fun batchDisassociateResourcesFromCustomLineItem(block: BatchDisassociateResourcesFromCustomLineItemRequest.Builder.() -> Unit) = batchDisassociateResourcesFromCustomLineItem(BatchDisassociateResourcesFromCustomLineItemRequest.Builder().apply(block).build())

    /**
     * Creates a billing group that resembles a consolidated billing family that Amazon Web Services charges, based off of the predefined pricing plan computation.
     */
    suspend fun createBillingGroup(input: CreateBillingGroupRequest): CreateBillingGroupResponse

    /**
     * Creates a billing group that resembles a consolidated billing family that Amazon Web Services charges, based off of the predefined pricing plan computation.
     */
    suspend fun createBillingGroup(block: CreateBillingGroupRequest.Builder.() -> Unit) = createBillingGroup(CreateBillingGroupRequest.Builder().apply(block).build())

    /**
     * Creates a custom line item that can be used to create a one-time fixed charge that can be applied to a single billing group for the current or previous billing period. The one-time fixed charge is either a fee or discount.
     */
    suspend fun createCustomLineItem(input: CreateCustomLineItemRequest): CreateCustomLineItemResponse

    /**
     * Creates a custom line item that can be used to create a one-time fixed charge that can be applied to a single billing group for the current or previous billing period. The one-time fixed charge is either a fee or discount.
     */
    suspend fun createCustomLineItem(block: CreateCustomLineItemRequest.Builder.() -> Unit) = createCustomLineItem(CreateCustomLineItemRequest.Builder().apply(block).build())

    /**
     * Creates a pricing plan that is used for computing Amazon Web Services charges for billing groups.
     */
    suspend fun createPricingPlan(input: CreatePricingPlanRequest): CreatePricingPlanResponse

    /**
     * Creates a pricing plan that is used for computing Amazon Web Services charges for billing groups.
     */
    suspend fun createPricingPlan(block: CreatePricingPlanRequest.Builder.() -> Unit) = createPricingPlan(CreatePricingPlanRequest.Builder().apply(block).build())

    /**
     * Creates a pricing rule can be associated to a pricing plan, or a set of pricing plans.
     */
    suspend fun createPricingRule(input: CreatePricingRuleRequest): CreatePricingRuleResponse

    /**
     * Creates a pricing rule can be associated to a pricing plan, or a set of pricing plans.
     */
    suspend fun createPricingRule(block: CreatePricingRuleRequest.Builder.() -> Unit) = createPricingRule(CreatePricingRuleRequest.Builder().apply(block).build())

    /**
     * Deletes a billing group.
     */
    suspend fun deleteBillingGroup(input: DeleteBillingGroupRequest): DeleteBillingGroupResponse

    /**
     * Deletes a billing group.
     */
    suspend fun deleteBillingGroup(block: DeleteBillingGroupRequest.Builder.() -> Unit) = deleteBillingGroup(DeleteBillingGroupRequest.Builder().apply(block).build())

    /**
     * Deletes the custom line item identified by the given ARN in the current, or previous billing period.
     */
    suspend fun deleteCustomLineItem(input: DeleteCustomLineItemRequest): DeleteCustomLineItemResponse

    /**
     * Deletes the custom line item identified by the given ARN in the current, or previous billing period.
     */
    suspend fun deleteCustomLineItem(block: DeleteCustomLineItemRequest.Builder.() -> Unit) = deleteCustomLineItem(DeleteCustomLineItemRequest.Builder().apply(block).build())

    /**
     * Deletes a pricing plan. The pricing plan must not be associated with any billing groups to delete successfully.
     */
    suspend fun deletePricingPlan(input: DeletePricingPlanRequest): DeletePricingPlanResponse

    /**
     * Deletes a pricing plan. The pricing plan must not be associated with any billing groups to delete successfully.
     */
    suspend fun deletePricingPlan(block: DeletePricingPlanRequest.Builder.() -> Unit) = deletePricingPlan(DeletePricingPlanRequest.Builder().apply(block).build())

    /**
     * Deletes the pricing rule identified by the input Amazon Resource Name (ARN).
     */
    suspend fun deletePricingRule(input: DeletePricingRuleRequest): DeletePricingRuleResponse

    /**
     * Deletes the pricing rule identified by the input Amazon Resource Name (ARN).
     */
    suspend fun deletePricingRule(block: DeletePricingRuleRequest.Builder.() -> Unit) = deletePricingRule(DeletePricingRuleRequest.Builder().apply(block).build())

    /**
     * Removes the specified list of account IDs from the given billing group.
     */
    suspend fun disassociateAccounts(input: DisassociateAccountsRequest): DisassociateAccountsResponse

    /**
     * Removes the specified list of account IDs from the given billing group.
     */
    suspend fun disassociateAccounts(block: DisassociateAccountsRequest.Builder.() -> Unit) = disassociateAccounts(DisassociateAccountsRequest.Builder().apply(block).build())

    /**
     * Disassociates a list of pricing rules from a pricing plan.
     */
    suspend fun disassociatePricingRules(input: DisassociatePricingRulesRequest): DisassociatePricingRulesResponse

    /**
     * Disassociates a list of pricing rules from a pricing plan.
     */
    suspend fun disassociatePricingRules(block: DisassociatePricingRulesRequest.Builder.() -> Unit) = disassociatePricingRules(DisassociatePricingRulesRequest.Builder().apply(block).build())

    /**
     * ***Amazon Web Services Billing Conductor is in beta release and is subject to change. Your use of Amazon Web Services Billing Conductor is subject to the Beta Service Participation terms of the [Amazon Web Services Service Terms](https://aws.amazon.com/service-terms/) (Section 1.10).***
     *
     *  This is a paginated call to list linked accounts that are linked to the payer account for the specified time period. If no information is provided, the current billing period is used. The response will optionally include the billing group associated with the linked account.
     */
    suspend fun listAccountAssociations(input: ListAccountAssociationsRequest = ListAccountAssociationsRequest {}): ListAccountAssociationsResponse

    /**
     * ***Amazon Web Services Billing Conductor is in beta release and is subject to change. Your use of Amazon Web Services Billing Conductor is subject to the Beta Service Participation terms of the [Amazon Web Services Service Terms](https://aws.amazon.com/service-terms/) (Section 1.10).***
     *
     *  This is a paginated call to list linked accounts that are linked to the payer account for the specified time period. If no information is provided, the current billing period is used. The response will optionally include the billing group associated with the linked account.
     */
    suspend fun listAccountAssociations(block: ListAccountAssociationsRequest.Builder.() -> Unit) = listAccountAssociations(ListAccountAssociationsRequest.Builder().apply(block).build())

    /**
     * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web Services charges based on the associated pricing plan of a billing group.
     */
    suspend fun listBillingGroupCostReports(input: ListBillingGroupCostReportsRequest = ListBillingGroupCostReportsRequest {}): ListBillingGroupCostReportsResponse

    /**
     * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web Services charges based on the associated pricing plan of a billing group.
     */
    suspend fun listBillingGroupCostReports(block: ListBillingGroupCostReportsRequest.Builder.() -> Unit) = listBillingGroupCostReports(ListBillingGroupCostReportsRequest.Builder().apply(block).build())

    /**
     * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a billing group, the current billing period is used.
     */
    suspend fun listBillingGroups(input: ListBillingGroupsRequest = ListBillingGroupsRequest {}): ListBillingGroupsResponse

    /**
     * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a billing group, the current billing period is used.
     */
    suspend fun listBillingGroups(block: ListBillingGroupsRequest.Builder.() -> Unit) = listBillingGroups(ListBillingGroupsRequest.Builder().apply(block).build())

    /**
     * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't provide a billing period, the current billing period is used.
     */
    suspend fun listCustomLineItems(input: ListCustomLineItemsRequest = ListCustomLineItemsRequest {}): ListCustomLineItemsResponse

    /**
     * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't provide a billing period, the current billing period is used.
     */
    suspend fun listCustomLineItems(block: ListCustomLineItemsRequest.Builder.() -> Unit) = listCustomLineItems(ListCustomLineItemsRequest.Builder().apply(block).build())

    /**
     * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the current billing period is used.
     */
    suspend fun listPricingPlans(input: ListPricingPlansRequest = ListPricingPlansRequest {}): ListPricingPlansResponse

    /**
     * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the current billing period is used.
     */
    suspend fun listPricingPlans(block: ListPricingPlansRequest.Builder.() -> Unit) = listPricingPlans(ListPricingPlansRequest.Builder().apply(block).build())

    /**
     * A list of the pricing plans associated with a pricing rule.
     */
    suspend fun listPricingPlansAssociatedWithPricingRule(input: ListPricingPlansAssociatedWithPricingRuleRequest): ListPricingPlansAssociatedWithPricingRuleResponse

    /**
     * A list of the pricing plans associated with a pricing rule.
     */
    suspend fun listPricingPlansAssociatedWithPricingRule(block: ListPricingPlansAssociatedWithPricingRuleRequest.Builder.() -> Unit) = listPricingPlansAssociatedWithPricingRule(ListPricingPlansAssociatedWithPricingRuleRequest.Builder().apply(block).build())

    /**
     * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
     */
    suspend fun listPricingRules(input: ListPricingRulesRequest = ListPricingRulesRequest {}): ListPricingRulesResponse

    /**
     * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
     */
    suspend fun listPricingRules(block: ListPricingRulesRequest.Builder.() -> Unit) = listPricingRules(ListPricingRulesRequest.Builder().apply(block).build())

    /**
     * Lists the pricing rules associated with a pricing plan.
     */
    suspend fun listPricingRulesAssociatedToPricingPlan(input: ListPricingRulesAssociatedToPricingPlanRequest): ListPricingRulesAssociatedToPricingPlanResponse

    /**
     * Lists the pricing rules associated with a pricing plan.
     */
    suspend fun listPricingRulesAssociatedToPricingPlan(block: ListPricingRulesAssociatedToPricingPlanRequest.Builder.() -> Unit) = listPricingRulesAssociatedToPricingPlan(ListPricingRulesAssociatedToPricingPlanRequest.Builder().apply(block).build())

    /**
     * List the resources associated to a custom line item.
     */
    suspend fun listResourcesAssociatedToCustomLineItem(input: ListResourcesAssociatedToCustomLineItemRequest): ListResourcesAssociatedToCustomLineItemResponse

    /**
     * List the resources associated to a custom line item.
     */
    suspend fun listResourcesAssociatedToCustomLineItem(block: ListResourcesAssociatedToCustomLineItemRequest.Builder.() -> Unit) = listResourcesAssociatedToCustomLineItem(ListResourcesAssociatedToCustomLineItemRequest.Builder().apply(block).build())

    /**
     * A list the tags for a resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * A list the tags for a resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Deletes specified tags from a resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Deletes specified tags from a resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * This updates an existing billing group.
     */
    suspend fun updateBillingGroup(input: UpdateBillingGroupRequest): UpdateBillingGroupResponse

    /**
     * This updates an existing billing group.
     */
    suspend fun updateBillingGroup(block: UpdateBillingGroupRequest.Builder.() -> Unit) = updateBillingGroup(UpdateBillingGroupRequest.Builder().apply(block).build())

    /**
     * Update an existing custom line item in the current or previous billing period.
     */
    suspend fun updateCustomLineItem(input: UpdateCustomLineItemRequest): UpdateCustomLineItemResponse

    /**
     * Update an existing custom line item in the current or previous billing period.
     */
    suspend fun updateCustomLineItem(block: UpdateCustomLineItemRequest.Builder.() -> Unit) = updateCustomLineItem(UpdateCustomLineItemRequest.Builder().apply(block).build())

    /**
     * This updates an existing pricing plan.
     */
    suspend fun updatePricingPlan(input: UpdatePricingPlanRequest): UpdatePricingPlanResponse

    /**
     * This updates an existing pricing plan.
     */
    suspend fun updatePricingPlan(block: UpdatePricingPlanRequest.Builder.() -> Unit) = updatePricingPlan(UpdatePricingPlanRequest.Builder().apply(block).build())

    /**
     * Updates an existing pricing rule.
     */
    suspend fun updatePricingRule(input: UpdatePricingRuleRequest): UpdatePricingRuleResponse

    /**
     * Updates an existing pricing rule.
     */
    suspend fun updatePricingRule(block: UpdatePricingRuleRequest.Builder.() -> Unit) = updatePricingRule(UpdatePricingRuleRequest.Builder().apply(block).build())
}
