// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockdataautomation.paginators

import aws.sdk.kotlin.services.bedrockdataautomation.BedrockDataAutomationClient
import aws.sdk.kotlin.services.bedrockdataautomation.model.BlueprintSummary
import aws.sdk.kotlin.services.bedrockdataautomation.model.DataAutomationProjectSummary
import aws.sdk.kotlin.services.bedrockdataautomation.model.ListBlueprintsRequest
import aws.sdk.kotlin.services.bedrockdataautomation.model.ListBlueprintsResponse
import aws.sdk.kotlin.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest
import aws.sdk.kotlin.services.bedrockdataautomation.model.ListDataAutomationProjectsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListBlueprintsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBlueprintsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBlueprintsResponse]
 */
public fun BedrockDataAutomationClient.listBlueprintsPaginated(initialRequest: ListBlueprintsRequest = ListBlueprintsRequest { }): Flow<ListBlueprintsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBlueprintsPaginated.listBlueprints(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBlueprintsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBlueprintsResponse]
 */
public fun BedrockDataAutomationClient.listBlueprintsPaginated(block: ListBlueprintsRequest.Builder.() -> Unit): Flow<ListBlueprintsResponse> =
    listBlueprintsPaginated(ListBlueprintsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBlueprintsPaginated]
 * to access the nested member [BlueprintSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BlueprintSummary]
 */
@JvmName("listBlueprintsResponseBlueprintSummary")
public fun Flow<ListBlueprintsResponse>.blueprints(): Flow<BlueprintSummary> =
    transform() { response ->
        response.blueprints?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataAutomationProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataAutomationProjectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataAutomationProjectsResponse]
 */
public fun BedrockDataAutomationClient.listDataAutomationProjectsPaginated(initialRequest: ListDataAutomationProjectsRequest = ListDataAutomationProjectsRequest { }): Flow<ListDataAutomationProjectsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataAutomationProjectsPaginated.listDataAutomationProjects(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDataAutomationProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataAutomationProjectsResponse]
 */
public fun BedrockDataAutomationClient.listDataAutomationProjectsPaginated(block: ListDataAutomationProjectsRequest.Builder.() -> Unit): Flow<ListDataAutomationProjectsResponse> =
    listDataAutomationProjectsPaginated(ListDataAutomationProjectsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataAutomationProjectsPaginated]
 * to access the nested member [DataAutomationProjectSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataAutomationProjectSummary]
 */
@JvmName("listDataAutomationProjectsResponseDataAutomationProjectSummary")
public fun Flow<ListDataAutomationProjectsResponse>.projects(): Flow<DataAutomationProjectSummary> =
    transform() { response ->
        response.projects?.forEach {
            emit(it)
        }
    }
