// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockdataautomation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the information of a DataAutomationProject.
 */
public class DataAutomationProject private constructor(builder: Builder) {
    /**
     * Time Stamp
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * Custom output configuration
     */
    public val customOutputConfiguration: aws.sdk.kotlin.services.bedrockdataautomation.model.CustomOutputConfiguration? = builder.customOutputConfiguration
    /**
     * KMS Encryption Context
     */
    public val kmsEncryptionContext: Map<String, String>? = builder.kmsEncryptionContext
    /**
     * KMS Key Identifier
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Time Stamp
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * Override configuration
     */
    public val overrideConfiguration: aws.sdk.kotlin.services.bedrockdataautomation.model.OverrideConfiguration? = builder.overrideConfiguration
    /**
     * ARN of a DataAutomationProject
     */
    public val projectArn: kotlin.String = requireNotNull(builder.projectArn) { "A non-null value must be provided for projectArn" }
    /**
     * Description of the DataAutomationProject
     */
    public val projectDescription: kotlin.String? = builder.projectDescription
    /**
     * Name of the DataAutomationProject
     */
    public val projectName: kotlin.String = requireNotNull(builder.projectName) { "A non-null value must be provided for projectName" }
    /**
     * Stage of the Project
     */
    public val projectStage: aws.sdk.kotlin.services.bedrockdataautomation.model.DataAutomationProjectStage? = builder.projectStage
    /**
     * Standard output configuration
     */
    public val standardOutputConfiguration: aws.sdk.kotlin.services.bedrockdataautomation.model.StandardOutputConfiguration? = builder.standardOutputConfiguration
    /**
     * Status of Data Automation Project
     */
    public val status: aws.sdk.kotlin.services.bedrockdataautomation.model.DataAutomationProjectStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrockdataautomation.model.DataAutomationProject = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataAutomationProject(")
        append("creationTime=$creationTime,")
        append("customOutputConfiguration=$customOutputConfiguration,")
        append("kmsEncryptionContext=$kmsEncryptionContext,")
        append("kmsKeyId=$kmsKeyId,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("overrideConfiguration=$overrideConfiguration,")
        append("projectArn=$projectArn,")
        append("projectDescription=*** Sensitive Data Redacted ***,")
        append("projectName=*** Sensitive Data Redacted ***,")
        append("projectStage=$projectStage,")
        append("standardOutputConfiguration=$standardOutputConfiguration,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (customOutputConfiguration?.hashCode() ?: 0)
        result = 31 * result + (kmsEncryptionContext?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (overrideConfiguration?.hashCode() ?: 0)
        result = 31 * result + (projectArn.hashCode())
        result = 31 * result + (projectDescription?.hashCode() ?: 0)
        result = 31 * result + (projectName.hashCode())
        result = 31 * result + (projectStage?.hashCode() ?: 0)
        result = 31 * result + (standardOutputConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataAutomationProject

        if (creationTime != other.creationTime) return false
        if (customOutputConfiguration != other.customOutputConfiguration) return false
        if (kmsEncryptionContext != other.kmsEncryptionContext) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (overrideConfiguration != other.overrideConfiguration) return false
        if (projectArn != other.projectArn) return false
        if (projectDescription != other.projectDescription) return false
        if (projectName != other.projectName) return false
        if (projectStage != other.projectStage) return false
        if (standardOutputConfiguration != other.standardOutputConfiguration) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrockdataautomation.model.DataAutomationProject = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Time Stamp
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Custom output configuration
         */
        public var customOutputConfiguration: aws.sdk.kotlin.services.bedrockdataautomation.model.CustomOutputConfiguration? = null
        /**
         * KMS Encryption Context
         */
        public var kmsEncryptionContext: Map<String, String>? = null
        /**
         * KMS Key Identifier
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Time Stamp
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Override configuration
         */
        public var overrideConfiguration: aws.sdk.kotlin.services.bedrockdataautomation.model.OverrideConfiguration? = null
        /**
         * ARN of a DataAutomationProject
         */
        public var projectArn: kotlin.String? = null
        /**
         * Description of the DataAutomationProject
         */
        public var projectDescription: kotlin.String? = null
        /**
         * Name of the DataAutomationProject
         */
        public var projectName: kotlin.String? = null
        /**
         * Stage of the Project
         */
        public var projectStage: aws.sdk.kotlin.services.bedrockdataautomation.model.DataAutomationProjectStage? = null
        /**
         * Standard output configuration
         */
        public var standardOutputConfiguration: aws.sdk.kotlin.services.bedrockdataautomation.model.StandardOutputConfiguration? = null
        /**
         * Status of Data Automation Project
         */
        public var status: aws.sdk.kotlin.services.bedrockdataautomation.model.DataAutomationProjectStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrockdataautomation.model.DataAutomationProject) : this() {
            this.creationTime = x.creationTime
            this.customOutputConfiguration = x.customOutputConfiguration
            this.kmsEncryptionContext = x.kmsEncryptionContext
            this.kmsKeyId = x.kmsKeyId
            this.lastModifiedTime = x.lastModifiedTime
            this.overrideConfiguration = x.overrideConfiguration
            this.projectArn = x.projectArn
            this.projectDescription = x.projectDescription
            this.projectName = x.projectName
            this.projectStage = x.projectStage
            this.standardOutputConfiguration = x.standardOutputConfiguration
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrockdataautomation.model.DataAutomationProject = DataAutomationProject(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrockdataautomation.model.CustomOutputConfiguration] inside the given [block]
         */
        public fun customOutputConfiguration(block: aws.sdk.kotlin.services.bedrockdataautomation.model.CustomOutputConfiguration.Builder.() -> kotlin.Unit) {
            this.customOutputConfiguration = aws.sdk.kotlin.services.bedrockdataautomation.model.CustomOutputConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrockdataautomation.model.OverrideConfiguration] inside the given [block]
         */
        public fun overrideConfiguration(block: aws.sdk.kotlin.services.bedrockdataautomation.model.OverrideConfiguration.Builder.() -> kotlin.Unit) {
            this.overrideConfiguration = aws.sdk.kotlin.services.bedrockdataautomation.model.OverrideConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrockdataautomation.model.StandardOutputConfiguration] inside the given [block]
         */
        public fun standardOutputConfiguration(block: aws.sdk.kotlin.services.bedrockdataautomation.model.StandardOutputConfiguration.Builder.() -> kotlin.Unit) {
            this.standardOutputConfiguration = aws.sdk.kotlin.services.bedrockdataautomation.model.StandardOutputConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            if (projectArn == null) projectArn = ""
            if (projectName == null) projectName = ""
            if (status == null) status = DataAutomationProjectStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
