// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockdataautomation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the information of a Blueprint.
 */
public class Blueprint private constructor(builder: Builder) {
    /**
     * ARN of a Blueprint
     */
    public val blueprintArn: kotlin.String = requireNotNull(builder.blueprintArn) { "A non-null value must be provided for blueprintArn" }
    /**
     * Name of the Blueprint
     */
    public val blueprintName: kotlin.String = requireNotNull(builder.blueprintName) { "A non-null value must be provided for blueprintName" }
    /**
     * Stage of the Blueprint
     */
    public val blueprintStage: aws.sdk.kotlin.services.bedrockdataautomation.model.BlueprintStage? = builder.blueprintStage
    /**
     * Blueprint Version
     */
    public val blueprintVersion: kotlin.String? = builder.blueprintVersion
    /**
     * Time Stamp
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * KMS Encryption Context
     */
    public val kmsEncryptionContext: Map<String, String>? = builder.kmsEncryptionContext
    /**
     * KMS Key Identifier
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Time Stamp
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * Schema of the blueprint
     */
    public val schema: kotlin.String = requireNotNull(builder.schema) { "A non-null value must be provided for schema" }
    /**
     * Type
     */
    public val type: aws.sdk.kotlin.services.bedrockdataautomation.model.Type = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrockdataautomation.model.Blueprint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Blueprint(")
        append("blueprintArn=$blueprintArn,")
        append("blueprintName=*** Sensitive Data Redacted ***,")
        append("blueprintStage=$blueprintStage,")
        append("blueprintVersion=$blueprintVersion,")
        append("creationTime=$creationTime,")
        append("kmsEncryptionContext=$kmsEncryptionContext,")
        append("kmsKeyId=$kmsKeyId,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("schema=*** Sensitive Data Redacted ***,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blueprintArn.hashCode()
        result = 31 * result + (blueprintName.hashCode())
        result = 31 * result + (blueprintStage?.hashCode() ?: 0)
        result = 31 * result + (blueprintVersion?.hashCode() ?: 0)
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (kmsEncryptionContext?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (schema.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Blueprint

        if (blueprintArn != other.blueprintArn) return false
        if (blueprintName != other.blueprintName) return false
        if (blueprintStage != other.blueprintStage) return false
        if (blueprintVersion != other.blueprintVersion) return false
        if (creationTime != other.creationTime) return false
        if (kmsEncryptionContext != other.kmsEncryptionContext) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (schema != other.schema) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrockdataautomation.model.Blueprint = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * ARN of a Blueprint
         */
        public var blueprintArn: kotlin.String? = null
        /**
         * Name of the Blueprint
         */
        public var blueprintName: kotlin.String? = null
        /**
         * Stage of the Blueprint
         */
        public var blueprintStage: aws.sdk.kotlin.services.bedrockdataautomation.model.BlueprintStage? = null
        /**
         * Blueprint Version
         */
        public var blueprintVersion: kotlin.String? = null
        /**
         * Time Stamp
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * KMS Encryption Context
         */
        public var kmsEncryptionContext: Map<String, String>? = null
        /**
         * KMS Key Identifier
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Time Stamp
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Schema of the blueprint
         */
        public var schema: kotlin.String? = null
        /**
         * Type
         */
        public var type: aws.sdk.kotlin.services.bedrockdataautomation.model.Type? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrockdataautomation.model.Blueprint) : this() {
            this.blueprintArn = x.blueprintArn
            this.blueprintName = x.blueprintName
            this.blueprintStage = x.blueprintStage
            this.blueprintVersion = x.blueprintVersion
            this.creationTime = x.creationTime
            this.kmsEncryptionContext = x.kmsEncryptionContext
            this.kmsKeyId = x.kmsKeyId
            this.lastModifiedTime = x.lastModifiedTime
            this.schema = x.schema
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrockdataautomation.model.Blueprint = Blueprint(this)

        internal fun correctErrors(): Builder {
            if (blueprintArn == null) blueprintArn = ""
            if (blueprintName == null) blueprintName = ""
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            if (schema == null) schema = ""
            if (type == null) type = Type.SdkUnknown("no value provided")
            return this
        }
    }
}
