// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockagent.serde

import aws.sdk.kotlin.services.bedrockagent.model.KnowledgeBaseConfiguration
import aws.sdk.kotlin.services.bedrockagent.model.StorageConfiguration
import aws.sdk.kotlin.services.bedrockagent.model.UpdateKnowledgeBaseRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateKnowledgeBaseOperationSerializer: HttpSerialize<UpdateKnowledgeBaseRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateKnowledgeBaseRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.knowledgeBaseId) { "knowledgeBaseId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("knowledgebases"))
                add(PercentEncoding.SmithyLabel.encode("${input.knowledgeBaseId}"))
            }
        }

        val payload = serializeUpdateKnowledgeBaseOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateKnowledgeBaseOperationBody(context: ExecutionContext, input: UpdateKnowledgeBaseRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val KNOWLEDGEBASECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("knowledgeBaseConfiguration"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STORAGECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("storageConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(KNOWLEDGEBASECONFIGURATION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STORAGECONFIGURATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.knowledgeBaseConfiguration?.let { field(KNOWLEDGEBASECONFIGURATION_DESCRIPTOR, it, ::serializeKnowledgeBaseConfigurationDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        input.storageConfiguration?.let { field(STORAGECONFIGURATION_DESCRIPTOR, it, ::serializeStorageConfigurationDocument) }
    }
    return serializer.toByteArray()
}
