// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockagent.serde

import aws.sdk.kotlin.services.bedrockagent.model.PromptOverrideConfiguration
import aws.sdk.kotlin.services.bedrockagent.model.UpdateAgentRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateAgentOperationSerializer: HttpSerialize<UpdateAgentRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateAgentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.agentId) { "agentId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("agents"))
                add(PercentEncoding.SmithyLabel.encode("${input.agentId}"))
            }
        }

        val payload = serializeUpdateAgentOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateAgentOperationBody(context: ExecutionContext, input: UpdateAgentRequest): ByteArray {
    val serializer = JsonSerializer()
    val AGENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("agentName"))
    val AGENTRESOURCEROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("agentResourceRoleArn"))
    val CUSTOMERENCRYPTIONKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customerEncryptionKeyArn"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val FOUNDATIONMODEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("foundationModel"))
    val IDLESESSIONTTLINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("idleSessionTTLInSeconds"))
    val INSTRUCTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("instruction"))
    val PROMPTOVERRIDECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("promptOverrideConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGENTNAME_DESCRIPTOR)
        field(AGENTRESOURCEROLEARN_DESCRIPTOR)
        field(CUSTOMERENCRYPTIONKEYARN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FOUNDATIONMODEL_DESCRIPTOR)
        field(IDLESESSIONTTLINSECONDS_DESCRIPTOR)
        field(INSTRUCTION_DESCRIPTOR)
        field(PROMPTOVERRIDECONFIGURATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.agentName?.let { field(AGENTNAME_DESCRIPTOR, it) }
        input.agentResourceRoleArn?.let { field(AGENTRESOURCEROLEARN_DESCRIPTOR, it) }
        input.customerEncryptionKeyArn?.let { field(CUSTOMERENCRYPTIONKEYARN_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.foundationModel?.let { field(FOUNDATIONMODEL_DESCRIPTOR, it) }
        input.idleSessionTtlInSeconds?.let { field(IDLESESSIONTTLINSECONDS_DESCRIPTOR, it) }
        input.instruction?.let { field(INSTRUCTION_DESCRIPTOR, it) }
        input.promptOverrideConfiguration?.let { field(PROMPTOVERRIDECONFIGURATION_DESCRIPTOR, it, ::serializePromptOverrideConfigurationDocument) }
    }
    return serializer.toByteArray()
}
