// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockagent.serde

import aws.sdk.kotlin.services.bedrockagent.model.CreateDataSourceRequest
import aws.sdk.kotlin.services.bedrockagent.model.DataSourceConfiguration
import aws.sdk.kotlin.services.bedrockagent.model.ServerSideEncryptionConfiguration
import aws.sdk.kotlin.services.bedrockagent.model.VectorIngestionConfiguration
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateDataSourceOperationSerializer: HttpSerialize<CreateDataSourceRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateDataSourceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.knowledgeBaseId) { "knowledgeBaseId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("knowledgebases"))
                add(PercentEncoding.SmithyLabel.encode("${input.knowledgeBaseId}"))
                add(PercentEncoding.Path.encode("datasources"))
            }
        }

        val payload = serializeCreateDataSourceOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateDataSourceOperationBody(context: ExecutionContext, input: CreateDataSourceRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val DATASOURCECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dataSourceConfiguration"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val SERVERSIDEENCRYPTIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("serverSideEncryptionConfiguration"))
    val VECTORINGESTIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vectorIngestionConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DATASOURCECONFIGURATION_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SERVERSIDEENCRYPTIONCONFIGURATION_DESCRIPTOR)
        field(VECTORINGESTIONCONFIGURATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.dataSourceConfiguration?.let { field(DATASOURCECONFIGURATION_DESCRIPTOR, it, ::serializeDataSourceConfigurationDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.serverSideEncryptionConfiguration?.let { field(SERVERSIDEENCRYPTIONCONFIGURATION_DESCRIPTOR, it, ::serializeServerSideEncryptionConfigurationDocument) }
        input.vectorIngestionConfiguration?.let { field(VECTORINGESTIONCONFIGURATION_DESCRIPTOR, it, ::serializeVectorIngestionConfigurationDocument) }
    }
    return serializer.toByteArray()
}
