// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockagent.serde

import aws.sdk.kotlin.services.bedrockagent.model.ActionGroupExecutor
import aws.sdk.kotlin.services.bedrockagent.model.ActionGroupSignature
import aws.sdk.kotlin.services.bedrockagent.model.ActionGroupState
import aws.sdk.kotlin.services.bedrockagent.model.ApiSchema
import aws.sdk.kotlin.services.bedrockagent.model.CreateAgentActionGroupRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateAgentActionGroupOperationSerializer: HttpSerialize<CreateAgentActionGroupRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateAgentActionGroupRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.agentId) { "agentId is bound to the URI and must not be null" }
            requireNotNull(input.agentVersion) { "agentVersion is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("agents"))
                add(PercentEncoding.SmithyLabel.encode("${input.agentId}"))
                add(PercentEncoding.Path.encode("agentversions"))
                add(PercentEncoding.SmithyLabel.encode("${input.agentVersion}"))
                add(PercentEncoding.Path.encode("actiongroups"))
            }
        }

        val payload = serializeCreateAgentActionGroupOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateAgentActionGroupOperationBody(context: ExecutionContext, input: CreateAgentActionGroupRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTIONGROUPEXECUTOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("actionGroupExecutor"))
    val ACTIONGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("actionGroupName"))
    val ACTIONGROUPSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("actionGroupState"))
    val APISCHEMA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("apiSchema"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val PARENTACTIONGROUPSIGNATURE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("parentActionGroupSignature"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONGROUPEXECUTOR_DESCRIPTOR)
        field(ACTIONGROUPNAME_DESCRIPTOR)
        field(ACTIONGROUPSTATE_DESCRIPTOR)
        field(APISCHEMA_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(PARENTACTIONGROUPSIGNATURE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.actionGroupExecutor?.let { field(ACTIONGROUPEXECUTOR_DESCRIPTOR, it, ::serializeActionGroupExecutorDocument) }
        input.actionGroupName?.let { field(ACTIONGROUPNAME_DESCRIPTOR, it) }
        input.actionGroupState?.let { field(ACTIONGROUPSTATE_DESCRIPTOR, it.value) }
        input.apiSchema?.let { field(APISCHEMA_DESCRIPTOR, it, ::serializeApiSchemaDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.parentActionGroupSignature?.let { field(PARENTACTIONGROUPSIGNATURE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
