// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockagent.model



/**
 * Configures the physical storage of ingested data in a knowledge base.
 */
public class StorageConfiguration private constructor(builder: Builder) {
    /**
     * Contains the configurations to use OpenSearch Serverless to store knowledge base data.
     */
    public val opensearchServerlessConfiguration: aws.sdk.kotlin.services.bedrockagent.model.OpenSearchServerlessConfiguration? = builder.opensearchServerlessConfiguration
    /**
     * Contains the configurations to use Pinecone to store knowledge base data.
     */
    public val pineconeConfiguration: aws.sdk.kotlin.services.bedrockagent.model.PineconeConfiguration? = builder.pineconeConfiguration
    /**
     * Contains the configurations to use RDS to store knowledge base data.
     */
    public val rdsConfiguration: aws.sdk.kotlin.services.bedrockagent.model.RdsConfiguration? = builder.rdsConfiguration
    /**
     * Contains the configurations to use Redis Enterprise Cloud to store knowledge base data.
     */
    public val redisEnterpriseCloudConfiguration: aws.sdk.kotlin.services.bedrockagent.model.RedisEnterpriseCloudConfiguration? = builder.redisEnterpriseCloudConfiguration
    /**
     * The storage type of a knowledge base.
     */
    public val type: aws.sdk.kotlin.services.bedrockagent.model.KnowledgeBaseStorageType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrockagent.model.StorageConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StorageConfiguration(")
        append("opensearchServerlessConfiguration=$opensearchServerlessConfiguration,")
        append("pineconeConfiguration=$pineconeConfiguration,")
        append("rdsConfiguration=$rdsConfiguration,")
        append("redisEnterpriseCloudConfiguration=$redisEnterpriseCloudConfiguration,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = opensearchServerlessConfiguration?.hashCode() ?: 0
        result = 31 * result + (pineconeConfiguration?.hashCode() ?: 0)
        result = 31 * result + (rdsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (redisEnterpriseCloudConfiguration?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StorageConfiguration

        if (opensearchServerlessConfiguration != other.opensearchServerlessConfiguration) return false
        if (pineconeConfiguration != other.pineconeConfiguration) return false
        if (rdsConfiguration != other.rdsConfiguration) return false
        if (redisEnterpriseCloudConfiguration != other.redisEnterpriseCloudConfiguration) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrockagent.model.StorageConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains the configurations to use OpenSearch Serverless to store knowledge base data.
         */
        public var opensearchServerlessConfiguration: aws.sdk.kotlin.services.bedrockagent.model.OpenSearchServerlessConfiguration? = null
        /**
         * Contains the configurations to use Pinecone to store knowledge base data.
         */
        public var pineconeConfiguration: aws.sdk.kotlin.services.bedrockagent.model.PineconeConfiguration? = null
        /**
         * Contains the configurations to use RDS to store knowledge base data.
         */
        public var rdsConfiguration: aws.sdk.kotlin.services.bedrockagent.model.RdsConfiguration? = null
        /**
         * Contains the configurations to use Redis Enterprise Cloud to store knowledge base data.
         */
        public var redisEnterpriseCloudConfiguration: aws.sdk.kotlin.services.bedrockagent.model.RedisEnterpriseCloudConfiguration? = null
        /**
         * The storage type of a knowledge base.
         */
        public var type: aws.sdk.kotlin.services.bedrockagent.model.KnowledgeBaseStorageType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrockagent.model.StorageConfiguration) : this() {
            this.opensearchServerlessConfiguration = x.opensearchServerlessConfiguration
            this.pineconeConfiguration = x.pineconeConfiguration
            this.rdsConfiguration = x.rdsConfiguration
            this.redisEnterpriseCloudConfiguration = x.redisEnterpriseCloudConfiguration
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrockagent.model.StorageConfiguration = StorageConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrockagent.model.OpenSearchServerlessConfiguration] inside the given [block]
         */
        public fun opensearchServerlessConfiguration(block: aws.sdk.kotlin.services.bedrockagent.model.OpenSearchServerlessConfiguration.Builder.() -> kotlin.Unit) {
            this.opensearchServerlessConfiguration = aws.sdk.kotlin.services.bedrockagent.model.OpenSearchServerlessConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrockagent.model.PineconeConfiguration] inside the given [block]
         */
        public fun pineconeConfiguration(block: aws.sdk.kotlin.services.bedrockagent.model.PineconeConfiguration.Builder.() -> kotlin.Unit) {
            this.pineconeConfiguration = aws.sdk.kotlin.services.bedrockagent.model.PineconeConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrockagent.model.RdsConfiguration] inside the given [block]
         */
        public fun rdsConfiguration(block: aws.sdk.kotlin.services.bedrockagent.model.RdsConfiguration.Builder.() -> kotlin.Unit) {
            this.rdsConfiguration = aws.sdk.kotlin.services.bedrockagent.model.RdsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrockagent.model.RedisEnterpriseCloudConfiguration] inside the given [block]
         */
        public fun redisEnterpriseCloudConfiguration(block: aws.sdk.kotlin.services.bedrockagent.model.RedisEnterpriseCloudConfiguration.Builder.() -> kotlin.Unit) {
            this.redisEnterpriseCloudConfiguration = aws.sdk.kotlin.services.bedrockagent.model.RedisEnterpriseCloudConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (type == null) type = KnowledgeBaseStorageType.SdkUnknown("no value provided")
            return this
        }
    }
}
