// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockagent.model



/**
 * Contains the configurations to use Redis Enterprise Cloud to store knowledge base data.
 */
public class RedisEnterpriseCloudConfiguration private constructor(builder: Builder) {
    /**
     * Arn of a SecretsManager Secret.
     */
    public val credentialsSecretArn: kotlin.String = requireNotNull(builder.credentialsSecretArn) { "A non-null value must be provided for credentialsSecretArn" }
    /**
     * Redis enterprise cloud endpoint
     */
    public val endpoint: kotlin.String = requireNotNull(builder.endpoint) { "A non-null value must be provided for endpoint" }
    /**
     * A mapping of Bedrock Knowledge Base fields to Redis Cloud field names
     */
    public val fieldMapping: aws.sdk.kotlin.services.bedrockagent.model.RedisEnterpriseCloudFieldMapping? = builder.fieldMapping
    /**
     * Name of a redis enterprise cloud index
     */
    public val vectorIndexName: kotlin.String = requireNotNull(builder.vectorIndexName) { "A non-null value must be provided for vectorIndexName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrockagent.model.RedisEnterpriseCloudConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedisEnterpriseCloudConfiguration(")
        append("credentialsSecretArn=$credentialsSecretArn,")
        append("endpoint=$endpoint,")
        append("fieldMapping=$fieldMapping,")
        append("vectorIndexName=$vectorIndexName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = credentialsSecretArn.hashCode()
        result = 31 * result + (endpoint.hashCode())
        result = 31 * result + (fieldMapping?.hashCode() ?: 0)
        result = 31 * result + (vectorIndexName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedisEnterpriseCloudConfiguration

        if (credentialsSecretArn != other.credentialsSecretArn) return false
        if (endpoint != other.endpoint) return false
        if (fieldMapping != other.fieldMapping) return false
        if (vectorIndexName != other.vectorIndexName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrockagent.model.RedisEnterpriseCloudConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Arn of a SecretsManager Secret.
         */
        public var credentialsSecretArn: kotlin.String? = null
        /**
         * Redis enterprise cloud endpoint
         */
        public var endpoint: kotlin.String? = null
        /**
         * A mapping of Bedrock Knowledge Base fields to Redis Cloud field names
         */
        public var fieldMapping: aws.sdk.kotlin.services.bedrockagent.model.RedisEnterpriseCloudFieldMapping? = null
        /**
         * Name of a redis enterprise cloud index
         */
        public var vectorIndexName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrockagent.model.RedisEnterpriseCloudConfiguration) : this() {
            this.credentialsSecretArn = x.credentialsSecretArn
            this.endpoint = x.endpoint
            this.fieldMapping = x.fieldMapping
            this.vectorIndexName = x.vectorIndexName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrockagent.model.RedisEnterpriseCloudConfiguration = RedisEnterpriseCloudConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrockagent.model.RedisEnterpriseCloudFieldMapping] inside the given [block]
         */
        public fun fieldMapping(block: aws.sdk.kotlin.services.bedrockagent.model.RedisEnterpriseCloudFieldMapping.Builder.() -> kotlin.Unit) {
            this.fieldMapping = aws.sdk.kotlin.services.bedrockagent.model.RedisEnterpriseCloudFieldMapping.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (credentialsSecretArn == null) credentialsSecretArn = ""
            if (endpoint == null) endpoint = ""
            if (vectorIndexName == null) vectorIndexName = ""
            return this
        }
    }
}
