// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockagent.model



/**
 * Contains the configurations to use RDS to store knowledge base data.
 */
public class RdsConfiguration private constructor(builder: Builder) {
    /**
     * Arn of a SecretsManager Secret.
     */
    public val credentialsSecretArn: kotlin.String = requireNotNull(builder.credentialsSecretArn) { "A non-null value must be provided for credentialsSecretArn" }
    /**
     * Name of the database within RDS
     */
    public val databaseName: kotlin.String = requireNotNull(builder.databaseName) { "A non-null value must be provided for databaseName" }
    /**
     * A mapping of Bedrock Knowledge Base fields to RDS column names
     */
    public val fieldMapping: aws.sdk.kotlin.services.bedrockagent.model.RdsFieldMapping? = builder.fieldMapping
    /**
     * Arn of a RDS Resource.
     */
    public val resourceArn: kotlin.String = requireNotNull(builder.resourceArn) { "A non-null value must be provided for resourceArn" }
    /**
     * Name of the table within RDS
     */
    public val tableName: kotlin.String = requireNotNull(builder.tableName) { "A non-null value must be provided for tableName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrockagent.model.RdsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RdsConfiguration(")
        append("credentialsSecretArn=$credentialsSecretArn,")
        append("databaseName=$databaseName,")
        append("fieldMapping=$fieldMapping,")
        append("resourceArn=$resourceArn,")
        append("tableName=$tableName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = credentialsSecretArn.hashCode()
        result = 31 * result + (databaseName.hashCode())
        result = 31 * result + (fieldMapping?.hashCode() ?: 0)
        result = 31 * result + (resourceArn.hashCode())
        result = 31 * result + (tableName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RdsConfiguration

        if (credentialsSecretArn != other.credentialsSecretArn) return false
        if (databaseName != other.databaseName) return false
        if (fieldMapping != other.fieldMapping) return false
        if (resourceArn != other.resourceArn) return false
        if (tableName != other.tableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrockagent.model.RdsConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Arn of a SecretsManager Secret.
         */
        public var credentialsSecretArn: kotlin.String? = null
        /**
         * Name of the database within RDS
         */
        public var databaseName: kotlin.String? = null
        /**
         * A mapping of Bedrock Knowledge Base fields to RDS column names
         */
        public var fieldMapping: aws.sdk.kotlin.services.bedrockagent.model.RdsFieldMapping? = null
        /**
         * Arn of a RDS Resource.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * Name of the table within RDS
         */
        public var tableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrockagent.model.RdsConfiguration) : this() {
            this.credentialsSecretArn = x.credentialsSecretArn
            this.databaseName = x.databaseName
            this.fieldMapping = x.fieldMapping
            this.resourceArn = x.resourceArn
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrockagent.model.RdsConfiguration = RdsConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrockagent.model.RdsFieldMapping] inside the given [block]
         */
        public fun fieldMapping(block: aws.sdk.kotlin.services.bedrockagent.model.RdsFieldMapping.Builder.() -> kotlin.Unit) {
            this.fieldMapping = aws.sdk.kotlin.services.bedrockagent.model.RdsFieldMapping.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (credentialsSecretArn == null) credentialsSecretArn = ""
            if (databaseName == null) databaseName = ""
            if (resourceArn == null) resourceArn = ""
            if (tableName == null) tableName = ""
            return this
        }
    }
}
