// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockagent.model



/**
 * Contains the configurations to use Pinecone to store knowledge base data.
 */
public class PineconeConfiguration private constructor(builder: Builder) {
    /**
     * Pinecone connection string
     */
    public val connectionString: kotlin.String = requireNotNull(builder.connectionString) { "A non-null value must be provided for connectionString" }
    /**
     * Arn of a SecretsManager Secret.
     */
    public val credentialsSecretArn: kotlin.String = requireNotNull(builder.credentialsSecretArn) { "A non-null value must be provided for credentialsSecretArn" }
    /**
     * A mapping of Bedrock Knowledge Base fields to Pinecone field names
     */
    public val fieldMapping: aws.sdk.kotlin.services.bedrockagent.model.PineconeFieldMapping? = builder.fieldMapping
    /**
     * Pinecone namespace
     */
    public val namespace: kotlin.String? = builder.namespace

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrockagent.model.PineconeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PineconeConfiguration(")
        append("connectionString=$connectionString,")
        append("credentialsSecretArn=$credentialsSecretArn,")
        append("fieldMapping=$fieldMapping,")
        append("namespace=$namespace")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectionString.hashCode()
        result = 31 * result + (credentialsSecretArn.hashCode())
        result = 31 * result + (fieldMapping?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PineconeConfiguration

        if (connectionString != other.connectionString) return false
        if (credentialsSecretArn != other.credentialsSecretArn) return false
        if (fieldMapping != other.fieldMapping) return false
        if (namespace != other.namespace) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrockagent.model.PineconeConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Pinecone connection string
         */
        public var connectionString: kotlin.String? = null
        /**
         * Arn of a SecretsManager Secret.
         */
        public var credentialsSecretArn: kotlin.String? = null
        /**
         * A mapping of Bedrock Knowledge Base fields to Pinecone field names
         */
        public var fieldMapping: aws.sdk.kotlin.services.bedrockagent.model.PineconeFieldMapping? = null
        /**
         * Pinecone namespace
         */
        public var namespace: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrockagent.model.PineconeConfiguration) : this() {
            this.connectionString = x.connectionString
            this.credentialsSecretArn = x.credentialsSecretArn
            this.fieldMapping = x.fieldMapping
            this.namespace = x.namespace
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrockagent.model.PineconeConfiguration = PineconeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrockagent.model.PineconeFieldMapping] inside the given [block]
         */
        public fun fieldMapping(block: aws.sdk.kotlin.services.bedrockagent.model.PineconeFieldMapping.Builder.() -> kotlin.Unit) {
            this.fieldMapping = aws.sdk.kotlin.services.bedrockagent.model.PineconeFieldMapping.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (connectionString == null) connectionString = ""
            if (credentialsSecretArn == null) credentialsSecretArn = ""
            return this
        }
    }
}
