// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockagent.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the information of a knowledge base.
 */
public class KnowledgeBase private constructor(builder: Builder) {
    /**
     * Time Stamp.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * Description of the Resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Failure Reasons for Error.
     */
    public val failureReasons: List<String>? = builder.failureReasons
    /**
     * ARN of a KnowledgeBase
     */
    public val knowledgeBaseArn: kotlin.String = requireNotNull(builder.knowledgeBaseArn) { "A non-null value must be provided for knowledgeBaseArn" }
    /**
     * Configures a bedrock knowledge base.
     */
    public val knowledgeBaseConfiguration: aws.sdk.kotlin.services.bedrockagent.model.KnowledgeBaseConfiguration? = builder.knowledgeBaseConfiguration
    /**
     * Identifier for a resource.
     */
    public val knowledgeBaseId: kotlin.String = requireNotNull(builder.knowledgeBaseId) { "A non-null value must be provided for knowledgeBaseId" }
    /**
     * Name for a resource.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * ARN of a IAM role.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The status of a knowledge base.
     */
    public val status: aws.sdk.kotlin.services.bedrockagent.model.KnowledgeBaseStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Configures the physical storage of ingested data in a knowledge base.
     */
    public val storageConfiguration: aws.sdk.kotlin.services.bedrockagent.model.StorageConfiguration? = builder.storageConfiguration
    /**
     * Time Stamp.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrockagent.model.KnowledgeBase = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KnowledgeBase(")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("failureReasons=$failureReasons,")
        append("knowledgeBaseArn=$knowledgeBaseArn,")
        append("knowledgeBaseConfiguration=$knowledgeBaseConfiguration,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("status=$status,")
        append("storageConfiguration=$storageConfiguration,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (failureReasons?.hashCode() ?: 0)
        result = 31 * result + (knowledgeBaseArn.hashCode())
        result = 31 * result + (knowledgeBaseConfiguration?.hashCode() ?: 0)
        result = 31 * result + (knowledgeBaseId.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (storageConfiguration?.hashCode() ?: 0)
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KnowledgeBase

        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (failureReasons != other.failureReasons) return false
        if (knowledgeBaseArn != other.knowledgeBaseArn) return false
        if (knowledgeBaseConfiguration != other.knowledgeBaseConfiguration) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false
        if (storageConfiguration != other.storageConfiguration) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrockagent.model.KnowledgeBase = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Time Stamp.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Description of the Resource.
         */
        public var description: kotlin.String? = null
        /**
         * Failure Reasons for Error.
         */
        public var failureReasons: List<String>? = null
        /**
         * ARN of a KnowledgeBase
         */
        public var knowledgeBaseArn: kotlin.String? = null
        /**
         * Configures a bedrock knowledge base.
         */
        public var knowledgeBaseConfiguration: aws.sdk.kotlin.services.bedrockagent.model.KnowledgeBaseConfiguration? = null
        /**
         * Identifier for a resource.
         */
        public var knowledgeBaseId: kotlin.String? = null
        /**
         * Name for a resource.
         */
        public var name: kotlin.String? = null
        /**
         * ARN of a IAM role.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The status of a knowledge base.
         */
        public var status: aws.sdk.kotlin.services.bedrockagent.model.KnowledgeBaseStatus? = null
        /**
         * Configures the physical storage of ingested data in a knowledge base.
         */
        public var storageConfiguration: aws.sdk.kotlin.services.bedrockagent.model.StorageConfiguration? = null
        /**
         * Time Stamp.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrockagent.model.KnowledgeBase) : this() {
            this.createdAt = x.createdAt
            this.description = x.description
            this.failureReasons = x.failureReasons
            this.knowledgeBaseArn = x.knowledgeBaseArn
            this.knowledgeBaseConfiguration = x.knowledgeBaseConfiguration
            this.knowledgeBaseId = x.knowledgeBaseId
            this.name = x.name
            this.roleArn = x.roleArn
            this.status = x.status
            this.storageConfiguration = x.storageConfiguration
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrockagent.model.KnowledgeBase = KnowledgeBase(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrockagent.model.KnowledgeBaseConfiguration] inside the given [block]
         */
        public fun knowledgeBaseConfiguration(block: aws.sdk.kotlin.services.bedrockagent.model.KnowledgeBaseConfiguration.Builder.() -> kotlin.Unit) {
            this.knowledgeBaseConfiguration = aws.sdk.kotlin.services.bedrockagent.model.KnowledgeBaseConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrockagent.model.StorageConfiguration] inside the given [block]
         */
        public fun storageConfiguration(block: aws.sdk.kotlin.services.bedrockagent.model.StorageConfiguration.Builder.() -> kotlin.Unit) {
            this.storageConfiguration = aws.sdk.kotlin.services.bedrockagent.model.StorageConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (knowledgeBaseArn == null) knowledgeBaseArn = ""
            if (knowledgeBaseId == null) knowledgeBaseId = ""
            if (name == null) name = ""
            if (roleArn == null) roleArn = ""
            if (status == null) status = KnowledgeBaseStatus.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
