// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockagent.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information of an ingestion job.
 */
public class IngestionJobSummary private constructor(builder: Builder) {
    /**
     * Identifier for a resource.
     */
    public val dataSourceId: kotlin.String = requireNotNull(builder.dataSourceId) { "A non-null value must be provided for dataSourceId" }
    /**
     * Description of the Resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Identifier for a resource.
     */
    public val ingestionJobId: kotlin.String = requireNotNull(builder.ingestionJobId) { "A non-null value must be provided for ingestionJobId" }
    /**
     * Identifier for a resource.
     */
    public val knowledgeBaseId: kotlin.String = requireNotNull(builder.knowledgeBaseId) { "A non-null value must be provided for knowledgeBaseId" }
    /**
     * Time Stamp.
     */
    public val startedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startedAt) { "A non-null value must be provided for startedAt" }
    /**
     * The document level statistics of an ingestion job
     */
    public val statistics: aws.sdk.kotlin.services.bedrockagent.model.IngestionJobStatistics? = builder.statistics
    /**
     * The status of an ingestion job.
     */
    public val status: aws.sdk.kotlin.services.bedrockagent.model.IngestionJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Time Stamp.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrockagent.model.IngestionJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IngestionJobSummary(")
        append("dataSourceId=$dataSourceId,")
        append("description=$description,")
        append("ingestionJobId=$ingestionJobId,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("startedAt=$startedAt,")
        append("statistics=$statistics,")
        append("status=$status,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceId.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (ingestionJobId.hashCode())
        result = 31 * result + (knowledgeBaseId.hashCode())
        result = 31 * result + (startedAt.hashCode())
        result = 31 * result + (statistics?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IngestionJobSummary

        if (dataSourceId != other.dataSourceId) return false
        if (description != other.description) return false
        if (ingestionJobId != other.ingestionJobId) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (startedAt != other.startedAt) return false
        if (statistics != other.statistics) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrockagent.model.IngestionJobSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Identifier for a resource.
         */
        public var dataSourceId: kotlin.String? = null
        /**
         * Description of the Resource.
         */
        public var description: kotlin.String? = null
        /**
         * Identifier for a resource.
         */
        public var ingestionJobId: kotlin.String? = null
        /**
         * Identifier for a resource.
         */
        public var knowledgeBaseId: kotlin.String? = null
        /**
         * Time Stamp.
         */
        public var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The document level statistics of an ingestion job
         */
        public var statistics: aws.sdk.kotlin.services.bedrockagent.model.IngestionJobStatistics? = null
        /**
         * The status of an ingestion job.
         */
        public var status: aws.sdk.kotlin.services.bedrockagent.model.IngestionJobStatus? = null
        /**
         * Time Stamp.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrockagent.model.IngestionJobSummary) : this() {
            this.dataSourceId = x.dataSourceId
            this.description = x.description
            this.ingestionJobId = x.ingestionJobId
            this.knowledgeBaseId = x.knowledgeBaseId
            this.startedAt = x.startedAt
            this.statistics = x.statistics
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrockagent.model.IngestionJobSummary = IngestionJobSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrockagent.model.IngestionJobStatistics] inside the given [block]
         */
        public fun statistics(block: aws.sdk.kotlin.services.bedrockagent.model.IngestionJobStatistics.Builder.() -> kotlin.Unit) {
            this.statistics = aws.sdk.kotlin.services.bedrockagent.model.IngestionJobStatistics.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (dataSourceId == null) dataSourceId = ""
            if (ingestionJobId == null) ingestionJobId = ""
            if (knowledgeBaseId == null) knowledgeBaseId = ""
            if (startedAt == null) startedAt = Instant.fromEpochSeconds(0)
            if (status == null) status = IngestionJobStatus.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
