// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockagent.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the information of a data source.
 */
public class DataSource private constructor(builder: Builder) {
    /**
     * Time Stamp.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * Specifies a raw data source location to ingest.
     */
    public val dataSourceConfiguration: aws.sdk.kotlin.services.bedrockagent.model.DataSourceConfiguration? = builder.dataSourceConfiguration
    /**
     * Identifier for a resource.
     */
    public val dataSourceId: kotlin.String = requireNotNull(builder.dataSourceId) { "A non-null value must be provided for dataSourceId" }
    /**
     * Description of the Resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Identifier for a resource.
     */
    public val knowledgeBaseId: kotlin.String = requireNotNull(builder.knowledgeBaseId) { "A non-null value must be provided for knowledgeBaseId" }
    /**
     * Name for a resource.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Server-side encryption configuration.
     */
    public val serverSideEncryptionConfiguration: aws.sdk.kotlin.services.bedrockagent.model.ServerSideEncryptionConfiguration? = builder.serverSideEncryptionConfiguration
    /**
     * The status of a data source.
     */
    public val status: aws.sdk.kotlin.services.bedrockagent.model.DataSourceStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Time Stamp.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }
    /**
     * Configures ingestion for a vector knowledge base
     */
    public val vectorIngestionConfiguration: aws.sdk.kotlin.services.bedrockagent.model.VectorIngestionConfiguration? = builder.vectorIngestionConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrockagent.model.DataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSource(")
        append("createdAt=$createdAt,")
        append("dataSourceConfiguration=$dataSourceConfiguration,")
        append("dataSourceId=$dataSourceId,")
        append("description=$description,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("name=$name,")
        append("serverSideEncryptionConfiguration=$serverSideEncryptionConfiguration,")
        append("status=$status,")
        append("updatedAt=$updatedAt,")
        append("vectorIngestionConfiguration=$vectorIngestionConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (dataSourceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (dataSourceId.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (knowledgeBaseId.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (serverSideEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        result = 31 * result + (vectorIngestionConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSource

        if (createdAt != other.createdAt) return false
        if (dataSourceConfiguration != other.dataSourceConfiguration) return false
        if (dataSourceId != other.dataSourceId) return false
        if (description != other.description) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (name != other.name) return false
        if (serverSideEncryptionConfiguration != other.serverSideEncryptionConfiguration) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false
        if (vectorIngestionConfiguration != other.vectorIngestionConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrockagent.model.DataSource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Time Stamp.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies a raw data source location to ingest.
         */
        public var dataSourceConfiguration: aws.sdk.kotlin.services.bedrockagent.model.DataSourceConfiguration? = null
        /**
         * Identifier for a resource.
         */
        public var dataSourceId: kotlin.String? = null
        /**
         * Description of the Resource.
         */
        public var description: kotlin.String? = null
        /**
         * Identifier for a resource.
         */
        public var knowledgeBaseId: kotlin.String? = null
        /**
         * Name for a resource.
         */
        public var name: kotlin.String? = null
        /**
         * Server-side encryption configuration.
         */
        public var serverSideEncryptionConfiguration: aws.sdk.kotlin.services.bedrockagent.model.ServerSideEncryptionConfiguration? = null
        /**
         * The status of a data source.
         */
        public var status: aws.sdk.kotlin.services.bedrockagent.model.DataSourceStatus? = null
        /**
         * Time Stamp.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Configures ingestion for a vector knowledge base
         */
        public var vectorIngestionConfiguration: aws.sdk.kotlin.services.bedrockagent.model.VectorIngestionConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrockagent.model.DataSource) : this() {
            this.createdAt = x.createdAt
            this.dataSourceConfiguration = x.dataSourceConfiguration
            this.dataSourceId = x.dataSourceId
            this.description = x.description
            this.knowledgeBaseId = x.knowledgeBaseId
            this.name = x.name
            this.serverSideEncryptionConfiguration = x.serverSideEncryptionConfiguration
            this.status = x.status
            this.updatedAt = x.updatedAt
            this.vectorIngestionConfiguration = x.vectorIngestionConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrockagent.model.DataSource = DataSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrockagent.model.DataSourceConfiguration] inside the given [block]
         */
        public fun dataSourceConfiguration(block: aws.sdk.kotlin.services.bedrockagent.model.DataSourceConfiguration.Builder.() -> kotlin.Unit) {
            this.dataSourceConfiguration = aws.sdk.kotlin.services.bedrockagent.model.DataSourceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrockagent.model.ServerSideEncryptionConfiguration] inside the given [block]
         */
        public fun serverSideEncryptionConfiguration(block: aws.sdk.kotlin.services.bedrockagent.model.ServerSideEncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.serverSideEncryptionConfiguration = aws.sdk.kotlin.services.bedrockagent.model.ServerSideEncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrockagent.model.VectorIngestionConfiguration] inside the given [block]
         */
        public fun vectorIngestionConfiguration(block: aws.sdk.kotlin.services.bedrockagent.model.VectorIngestionConfiguration.Builder.() -> kotlin.Unit) {
            this.vectorIngestionConfiguration = aws.sdk.kotlin.services.bedrockagent.model.VectorIngestionConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (dataSourceId == null) dataSourceId = ""
            if (knowledgeBaseId == null) knowledgeBaseId = ""
            if (name == null) name = ""
            if (status == null) status = DataSourceStatus.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
