// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockagent.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the information of an agent version.
 */
public class AgentVersion private constructor(builder: Builder) {
    /**
     * Arn representation of the Agent.
     */
    public val agentArn: kotlin.String = requireNotNull(builder.agentArn) { "A non-null value must be provided for agentArn" }
    /**
     * Identifier for a resource.
     */
    public val agentId: kotlin.String = requireNotNull(builder.agentId) { "A non-null value must be provided for agentId" }
    /**
     * Name for a resource.
     */
    public val agentName: kotlin.String = requireNotNull(builder.agentName) { "A non-null value must be provided for agentName" }
    /**
     * ARN of a IAM role.
     */
    public val agentResourceRoleArn: kotlin.String = requireNotNull(builder.agentResourceRoleArn) { "A non-null value must be provided for agentResourceRoleArn" }
    /**
     * Schema Type for Action APIs.
     */
    public val agentStatus: aws.sdk.kotlin.services.bedrockagent.model.AgentStatus = requireNotNull(builder.agentStatus) { "A non-null value must be provided for agentStatus" }
    /**
     * Time Stamp.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * A KMS key ARN
     */
    public val customerEncryptionKeyArn: kotlin.String? = builder.customerEncryptionKeyArn
    /**
     * Description of the Resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Failure Reasons for Error.
     */
    public val failureReasons: List<String>? = builder.failureReasons
    /**
     * ARN or name of a Bedrock model.
     */
    public val foundationModel: kotlin.String? = builder.foundationModel
    /**
     * Max Session Time.
     */
    public val idleSessionTtlInSeconds: kotlin.Int = requireNotNull(builder.idleSessionTtlInSeconds) { "A non-null value must be provided for idleSessionTtlInSeconds" }
    /**
     * Instruction for the agent.
     */
    public val instruction: kotlin.String? = builder.instruction
    /**
     * Configuration for prompt override.
     */
    public val promptOverrideConfiguration: aws.sdk.kotlin.services.bedrockagent.model.PromptOverrideConfiguration? = builder.promptOverrideConfiguration
    /**
     * The recommended actions users can take to resolve an error in failureReasons.
     */
    public val recommendedActions: List<String>? = builder.recommendedActions
    /**
     * Time Stamp.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }
    /**
     * Numerical Agent Version.
     */
    public val version: kotlin.String = requireNotNull(builder.version) { "A non-null value must be provided for version" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrockagent.model.AgentVersion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AgentVersion(")
        append("agentArn=$agentArn,")
        append("agentId=$agentId,")
        append("agentName=$agentName,")
        append("agentResourceRoleArn=$agentResourceRoleArn,")
        append("agentStatus=$agentStatus,")
        append("createdAt=$createdAt,")
        append("customerEncryptionKeyArn=$customerEncryptionKeyArn,")
        append("description=$description,")
        append("failureReasons=$failureReasons,")
        append("foundationModel=$foundationModel,")
        append("idleSessionTtlInSeconds=$idleSessionTtlInSeconds,")
        append("instruction=*** Sensitive Data Redacted ***,")
        append("promptOverrideConfiguration=*** Sensitive Data Redacted ***,")
        append("recommendedActions=$recommendedActions,")
        append("updatedAt=$updatedAt,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentArn.hashCode()
        result = 31 * result + (agentId.hashCode())
        result = 31 * result + (agentName.hashCode())
        result = 31 * result + (agentResourceRoleArn.hashCode())
        result = 31 * result + (agentStatus.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (customerEncryptionKeyArn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (failureReasons?.hashCode() ?: 0)
        result = 31 * result + (foundationModel?.hashCode() ?: 0)
        result = 31 * result + (idleSessionTtlInSeconds)
        result = 31 * result + (instruction?.hashCode() ?: 0)
        result = 31 * result + (promptOverrideConfiguration?.hashCode() ?: 0)
        result = 31 * result + (recommendedActions?.hashCode() ?: 0)
        result = 31 * result + (updatedAt.hashCode())
        result = 31 * result + (version.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AgentVersion

        if (agentArn != other.agentArn) return false
        if (agentId != other.agentId) return false
        if (agentName != other.agentName) return false
        if (agentResourceRoleArn != other.agentResourceRoleArn) return false
        if (agentStatus != other.agentStatus) return false
        if (createdAt != other.createdAt) return false
        if (customerEncryptionKeyArn != other.customerEncryptionKeyArn) return false
        if (description != other.description) return false
        if (failureReasons != other.failureReasons) return false
        if (foundationModel != other.foundationModel) return false
        if (idleSessionTtlInSeconds != other.idleSessionTtlInSeconds) return false
        if (instruction != other.instruction) return false
        if (promptOverrideConfiguration != other.promptOverrideConfiguration) return false
        if (recommendedActions != other.recommendedActions) return false
        if (updatedAt != other.updatedAt) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrockagent.model.AgentVersion = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Arn representation of the Agent.
         */
        public var agentArn: kotlin.String? = null
        /**
         * Identifier for a resource.
         */
        public var agentId: kotlin.String? = null
        /**
         * Name for a resource.
         */
        public var agentName: kotlin.String? = null
        /**
         * ARN of a IAM role.
         */
        public var agentResourceRoleArn: kotlin.String? = null
        /**
         * Schema Type for Action APIs.
         */
        public var agentStatus: aws.sdk.kotlin.services.bedrockagent.model.AgentStatus? = null
        /**
         * Time Stamp.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A KMS key ARN
         */
        public var customerEncryptionKeyArn: kotlin.String? = null
        /**
         * Description of the Resource.
         */
        public var description: kotlin.String? = null
        /**
         * Failure Reasons for Error.
         */
        public var failureReasons: List<String>? = null
        /**
         * ARN or name of a Bedrock model.
         */
        public var foundationModel: kotlin.String? = null
        /**
         * Max Session Time.
         */
        public var idleSessionTtlInSeconds: kotlin.Int? = null
        /**
         * Instruction for the agent.
         */
        public var instruction: kotlin.String? = null
        /**
         * Configuration for prompt override.
         */
        public var promptOverrideConfiguration: aws.sdk.kotlin.services.bedrockagent.model.PromptOverrideConfiguration? = null
        /**
         * The recommended actions users can take to resolve an error in failureReasons.
         */
        public var recommendedActions: List<String>? = null
        /**
         * Time Stamp.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Numerical Agent Version.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrockagent.model.AgentVersion) : this() {
            this.agentArn = x.agentArn
            this.agentId = x.agentId
            this.agentName = x.agentName
            this.agentResourceRoleArn = x.agentResourceRoleArn
            this.agentStatus = x.agentStatus
            this.createdAt = x.createdAt
            this.customerEncryptionKeyArn = x.customerEncryptionKeyArn
            this.description = x.description
            this.failureReasons = x.failureReasons
            this.foundationModel = x.foundationModel
            this.idleSessionTtlInSeconds = x.idleSessionTtlInSeconds
            this.instruction = x.instruction
            this.promptOverrideConfiguration = x.promptOverrideConfiguration
            this.recommendedActions = x.recommendedActions
            this.updatedAt = x.updatedAt
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrockagent.model.AgentVersion = AgentVersion(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrockagent.model.PromptOverrideConfiguration] inside the given [block]
         */
        public fun promptOverrideConfiguration(block: aws.sdk.kotlin.services.bedrockagent.model.PromptOverrideConfiguration.Builder.() -> kotlin.Unit) {
            this.promptOverrideConfiguration = aws.sdk.kotlin.services.bedrockagent.model.PromptOverrideConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (agentArn == null) agentArn = ""
            if (agentId == null) agentId = ""
            if (agentName == null) agentName = ""
            if (agentResourceRoleArn == null) agentResourceRoleArn = ""
            if (agentStatus == null) agentStatus = AgentStatus.SdkUnknown("no value provided")
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (idleSessionTtlInSeconds == null) idleSessionTtlInSeconds = 0
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            if (version == null) version = ""
            return this
        }
    }
}
