// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockagent.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the information of an Agent Knowledge Base.
 */
public class AgentKnowledgeBase private constructor(builder: Builder) {
    /**
     * Identifier for a resource.
     */
    public val agentId: kotlin.String = requireNotNull(builder.agentId) { "A non-null value must be provided for agentId" }
    /**
     * Agent Version.
     */
    public val agentVersion: kotlin.String = requireNotNull(builder.agentVersion) { "A non-null value must be provided for agentVersion" }
    /**
     * Time Stamp.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * Description of the Resource.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * Identifier for a resource.
     */
    public val knowledgeBaseId: kotlin.String = requireNotNull(builder.knowledgeBaseId) { "A non-null value must be provided for knowledgeBaseId" }
    /**
     * State of the knowledge base; whether it is enabled or disabled
     */
    public val knowledgeBaseState: aws.sdk.kotlin.services.bedrockagent.model.KnowledgeBaseState = requireNotNull(builder.knowledgeBaseState) { "A non-null value must be provided for knowledgeBaseState" }
    /**
     * Time Stamp.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrockagent.model.AgentKnowledgeBase = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AgentKnowledgeBase(")
        append("agentId=$agentId,")
        append("agentVersion=$agentVersion,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("knowledgeBaseId=$knowledgeBaseId,")
        append("knowledgeBaseState=$knowledgeBaseState,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentId.hashCode()
        result = 31 * result + (agentVersion.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (description.hashCode())
        result = 31 * result + (knowledgeBaseId.hashCode())
        result = 31 * result + (knowledgeBaseState.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AgentKnowledgeBase

        if (agentId != other.agentId) return false
        if (agentVersion != other.agentVersion) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (knowledgeBaseId != other.knowledgeBaseId) return false
        if (knowledgeBaseState != other.knowledgeBaseState) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrockagent.model.AgentKnowledgeBase = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Identifier for a resource.
         */
        public var agentId: kotlin.String? = null
        /**
         * Agent Version.
         */
        public var agentVersion: kotlin.String? = null
        /**
         * Time Stamp.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Description of the Resource.
         */
        public var description: kotlin.String? = null
        /**
         * Identifier for a resource.
         */
        public var knowledgeBaseId: kotlin.String? = null
        /**
         * State of the knowledge base; whether it is enabled or disabled
         */
        public var knowledgeBaseState: aws.sdk.kotlin.services.bedrockagent.model.KnowledgeBaseState? = null
        /**
         * Time Stamp.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrockagent.model.AgentKnowledgeBase) : this() {
            this.agentId = x.agentId
            this.agentVersion = x.agentVersion
            this.createdAt = x.createdAt
            this.description = x.description
            this.knowledgeBaseId = x.knowledgeBaseId
            this.knowledgeBaseState = x.knowledgeBaseState
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrockagent.model.AgentKnowledgeBase = AgentKnowledgeBase(this)

        internal fun correctErrors(): Builder {
            if (agentId == null) agentId = ""
            if (agentVersion == null) agentVersion = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (description == null) description = ""
            if (knowledgeBaseId == null) knowledgeBaseId = ""
            if (knowledgeBaseState == null) knowledgeBaseState = KnowledgeBaseState.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
