// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockagent

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.bedrockagent.auth.BedrockAgentAuthSchemeProvider
import aws.sdk.kotlin.services.bedrockagent.auth.DefaultBedrockAgentAuthSchemeProvider
import aws.sdk.kotlin.services.bedrockagent.endpoints.BedrockAgentEndpointParameters
import aws.sdk.kotlin.services.bedrockagent.endpoints.BedrockAgentEndpointProvider
import aws.sdk.kotlin.services.bedrockagent.endpoints.DefaultBedrockAgentEndpointProvider
import aws.sdk.kotlin.services.bedrockagent.model.AssociateAgentKnowledgeBaseRequest
import aws.sdk.kotlin.services.bedrockagent.model.AssociateAgentKnowledgeBaseResponse
import aws.sdk.kotlin.services.bedrockagent.model.CreateAgentActionGroupRequest
import aws.sdk.kotlin.services.bedrockagent.model.CreateAgentActionGroupResponse
import aws.sdk.kotlin.services.bedrockagent.model.CreateAgentAliasRequest
import aws.sdk.kotlin.services.bedrockagent.model.CreateAgentAliasResponse
import aws.sdk.kotlin.services.bedrockagent.model.CreateAgentRequest
import aws.sdk.kotlin.services.bedrockagent.model.CreateAgentResponse
import aws.sdk.kotlin.services.bedrockagent.model.CreateDataSourceRequest
import aws.sdk.kotlin.services.bedrockagent.model.CreateDataSourceResponse
import aws.sdk.kotlin.services.bedrockagent.model.CreateKnowledgeBaseRequest
import aws.sdk.kotlin.services.bedrockagent.model.CreateKnowledgeBaseResponse
import aws.sdk.kotlin.services.bedrockagent.model.DeleteAgentActionGroupRequest
import aws.sdk.kotlin.services.bedrockagent.model.DeleteAgentActionGroupResponse
import aws.sdk.kotlin.services.bedrockagent.model.DeleteAgentAliasRequest
import aws.sdk.kotlin.services.bedrockagent.model.DeleteAgentAliasResponse
import aws.sdk.kotlin.services.bedrockagent.model.DeleteAgentRequest
import aws.sdk.kotlin.services.bedrockagent.model.DeleteAgentResponse
import aws.sdk.kotlin.services.bedrockagent.model.DeleteAgentVersionRequest
import aws.sdk.kotlin.services.bedrockagent.model.DeleteAgentVersionResponse
import aws.sdk.kotlin.services.bedrockagent.model.DeleteDataSourceRequest
import aws.sdk.kotlin.services.bedrockagent.model.DeleteDataSourceResponse
import aws.sdk.kotlin.services.bedrockagent.model.DeleteKnowledgeBaseRequest
import aws.sdk.kotlin.services.bedrockagent.model.DeleteKnowledgeBaseResponse
import aws.sdk.kotlin.services.bedrockagent.model.DisassociateAgentKnowledgeBaseRequest
import aws.sdk.kotlin.services.bedrockagent.model.DisassociateAgentKnowledgeBaseResponse
import aws.sdk.kotlin.services.bedrockagent.model.GetAgentActionGroupRequest
import aws.sdk.kotlin.services.bedrockagent.model.GetAgentActionGroupResponse
import aws.sdk.kotlin.services.bedrockagent.model.GetAgentAliasRequest
import aws.sdk.kotlin.services.bedrockagent.model.GetAgentAliasResponse
import aws.sdk.kotlin.services.bedrockagent.model.GetAgentKnowledgeBaseRequest
import aws.sdk.kotlin.services.bedrockagent.model.GetAgentKnowledgeBaseResponse
import aws.sdk.kotlin.services.bedrockagent.model.GetAgentRequest
import aws.sdk.kotlin.services.bedrockagent.model.GetAgentResponse
import aws.sdk.kotlin.services.bedrockagent.model.GetAgentVersionRequest
import aws.sdk.kotlin.services.bedrockagent.model.GetAgentVersionResponse
import aws.sdk.kotlin.services.bedrockagent.model.GetDataSourceRequest
import aws.sdk.kotlin.services.bedrockagent.model.GetDataSourceResponse
import aws.sdk.kotlin.services.bedrockagent.model.GetIngestionJobRequest
import aws.sdk.kotlin.services.bedrockagent.model.GetIngestionJobResponse
import aws.sdk.kotlin.services.bedrockagent.model.GetKnowledgeBaseRequest
import aws.sdk.kotlin.services.bedrockagent.model.GetKnowledgeBaseResponse
import aws.sdk.kotlin.services.bedrockagent.model.ListAgentActionGroupsRequest
import aws.sdk.kotlin.services.bedrockagent.model.ListAgentActionGroupsResponse
import aws.sdk.kotlin.services.bedrockagent.model.ListAgentAliasesRequest
import aws.sdk.kotlin.services.bedrockagent.model.ListAgentAliasesResponse
import aws.sdk.kotlin.services.bedrockagent.model.ListAgentKnowledgeBasesRequest
import aws.sdk.kotlin.services.bedrockagent.model.ListAgentKnowledgeBasesResponse
import aws.sdk.kotlin.services.bedrockagent.model.ListAgentVersionsRequest
import aws.sdk.kotlin.services.bedrockagent.model.ListAgentVersionsResponse
import aws.sdk.kotlin.services.bedrockagent.model.ListAgentsRequest
import aws.sdk.kotlin.services.bedrockagent.model.ListAgentsResponse
import aws.sdk.kotlin.services.bedrockagent.model.ListDataSourcesRequest
import aws.sdk.kotlin.services.bedrockagent.model.ListDataSourcesResponse
import aws.sdk.kotlin.services.bedrockagent.model.ListIngestionJobsRequest
import aws.sdk.kotlin.services.bedrockagent.model.ListIngestionJobsResponse
import aws.sdk.kotlin.services.bedrockagent.model.ListKnowledgeBasesRequest
import aws.sdk.kotlin.services.bedrockagent.model.ListKnowledgeBasesResponse
import aws.sdk.kotlin.services.bedrockagent.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.bedrockagent.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.bedrockagent.model.PrepareAgentRequest
import aws.sdk.kotlin.services.bedrockagent.model.PrepareAgentResponse
import aws.sdk.kotlin.services.bedrockagent.model.StartIngestionJobRequest
import aws.sdk.kotlin.services.bedrockagent.model.StartIngestionJobResponse
import aws.sdk.kotlin.services.bedrockagent.model.TagResourceRequest
import aws.sdk.kotlin.services.bedrockagent.model.TagResourceResponse
import aws.sdk.kotlin.services.bedrockagent.model.UntagResourceRequest
import aws.sdk.kotlin.services.bedrockagent.model.UntagResourceResponse
import aws.sdk.kotlin.services.bedrockagent.model.UpdateAgentActionGroupRequest
import aws.sdk.kotlin.services.bedrockagent.model.UpdateAgentActionGroupResponse
import aws.sdk.kotlin.services.bedrockagent.model.UpdateAgentAliasRequest
import aws.sdk.kotlin.services.bedrockagent.model.UpdateAgentAliasResponse
import aws.sdk.kotlin.services.bedrockagent.model.UpdateAgentKnowledgeBaseRequest
import aws.sdk.kotlin.services.bedrockagent.model.UpdateAgentKnowledgeBaseResponse
import aws.sdk.kotlin.services.bedrockagent.model.UpdateAgentRequest
import aws.sdk.kotlin.services.bedrockagent.model.UpdateAgentResponse
import aws.sdk.kotlin.services.bedrockagent.model.UpdateDataSourceRequest
import aws.sdk.kotlin.services.bedrockagent.model.UpdateDataSourceResponse
import aws.sdk.kotlin.services.bedrockagent.model.UpdateKnowledgeBaseRequest
import aws.sdk.kotlin.services.bedrockagent.model.UpdateKnowledgeBaseResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Bedrock Agent"
public const val SdkVersion: String = "1.0.33"
public const val ServiceApiVersion: String = "2023-06-05"

/**
 * An example service, deployed with the Octane Service creator, which will echo the string
 */
public interface BedrockAgentClient : SdkClient {
    /**
     * BedrockAgentClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, BedrockAgentClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "BedrockAgent",
                "BEDROCK_AGENT",
                "bedrock_agent",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, BedrockAgentClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): BedrockAgentClient = DefaultBedrockAgentClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: BedrockAgentEndpointProvider = builder.endpointProvider ?: DefaultBedrockAgentEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: BedrockAgentAuthSchemeProvider = builder.authSchemeProvider ?: DefaultBedrockAgentAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Bedrock Agent"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: BedrockAgentEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: BedrockAgentAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associate a Knowledge Base to an existing Amazon Bedrock Agent
     */
    public suspend fun associateAgentKnowledgeBase(input: AssociateAgentKnowledgeBaseRequest): AssociateAgentKnowledgeBaseResponse

    /**
     * Creates an Amazon Bedrock Agent
     */
    public suspend fun createAgent(input: CreateAgentRequest): CreateAgentResponse

    /**
     * Creates an Action Group for existing Amazon Bedrock Agent
     */
    public suspend fun createAgentActionGroup(input: CreateAgentActionGroupRequest): CreateAgentActionGroupResponse

    /**
     * Creates an Alias for an existing Amazon Bedrock Agent
     */
    public suspend fun createAgentAlias(input: CreateAgentAliasRequest): CreateAgentAliasResponse

    /**
     * Create a new data source
     */
    public suspend fun createDataSource(input: CreateDataSourceRequest): CreateDataSourceResponse

    /**
     * Create a new knowledge base
     */
    public suspend fun createKnowledgeBase(input: CreateKnowledgeBaseRequest): CreateKnowledgeBaseResponse

    /**
     * Deletes an Agent for existing Amazon Bedrock Agent
     */
    public suspend fun deleteAgent(input: DeleteAgentRequest): DeleteAgentResponse

    /**
     * Deletes an Action Group for existing Amazon Bedrock Agent.
     */
    public suspend fun deleteAgentActionGroup(input: DeleteAgentActionGroupRequest): DeleteAgentActionGroupResponse

    /**
     * Deletes an Alias for a Amazon Bedrock Agent
     */
    public suspend fun deleteAgentAlias(input: DeleteAgentAliasRequest): DeleteAgentAliasResponse

    /**
     * Deletes an Agent version for existing Amazon Bedrock Agent
     */
    public suspend fun deleteAgentVersion(input: DeleteAgentVersionRequest): DeleteAgentVersionResponse

    /**
     * Delete an existing data source
     */
    public suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse

    /**
     * Delete an existing knowledge base
     */
    public suspend fun deleteKnowledgeBase(input: DeleteKnowledgeBaseRequest): DeleteKnowledgeBaseResponse

    /**
     * Disassociate an existing Knowledge Base from an Amazon Bedrock Agent
     */
    public suspend fun disassociateAgentKnowledgeBase(input: DisassociateAgentKnowledgeBaseRequest): DisassociateAgentKnowledgeBaseResponse

    /**
     * Gets an Agent for existing Amazon Bedrock Agent
     */
    public suspend fun getAgent(input: GetAgentRequest): GetAgentResponse

    /**
     * Gets an Action Group for existing Amazon Bedrock Agent Version
     */
    public suspend fun getAgentActionGroup(input: GetAgentActionGroupRequest): GetAgentActionGroupResponse

    /**
     * Describes an Alias for a Amazon Bedrock Agent
     */
    public suspend fun getAgentAlias(input: GetAgentAliasRequest): GetAgentAliasResponse

    /**
     * Gets a knowledge base associated to an existing Amazon Bedrock Agent Version
     */
    public suspend fun getAgentKnowledgeBase(input: GetAgentKnowledgeBaseRequest): GetAgentKnowledgeBaseResponse

    /**
     * Gets an Agent version for existing Amazon Bedrock Agent
     */
    public suspend fun getAgentVersion(input: GetAgentVersionRequest): GetAgentVersionResponse

    /**
     * Get an existing data source
     */
    public suspend fun getDataSource(input: GetDataSourceRequest): GetDataSourceResponse

    /**
     * Get an ingestion job
     */
    public suspend fun getIngestionJob(input: GetIngestionJobRequest): GetIngestionJobResponse

    /**
     * Get an existing knowledge base
     */
    public suspend fun getKnowledgeBase(input: GetKnowledgeBaseRequest): GetKnowledgeBaseResponse

    /**
     * Lists an Action Group for existing Amazon Bedrock Agent Version
     */
    public suspend fun listAgentActionGroups(input: ListAgentActionGroupsRequest): ListAgentActionGroupsResponse

    /**
     * Lists all the Aliases for an Amazon Bedrock Agent
     */
    public suspend fun listAgentAliases(input: ListAgentAliasesRequest): ListAgentAliasesResponse

    /**
     * List of Knowledge Bases associated to an existing Amazon Bedrock Agent Version
     */
    public suspend fun listAgentKnowledgeBases(input: ListAgentKnowledgeBasesRequest): ListAgentKnowledgeBasesResponse

    /**
     * Lists Agent Versions
     */
    public suspend fun listAgentVersions(input: ListAgentVersionsRequest): ListAgentVersionsResponse

    /**
     * Lists Agents
     */
    public suspend fun listAgents(input: ListAgentsRequest = ListAgentsRequest { }): ListAgentsResponse

    /**
     * List data sources
     */
    public suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse

    /**
     * List ingestion jobs
     */
    public suspend fun listIngestionJobs(input: ListIngestionJobsRequest): ListIngestionJobsResponse

    /**
     * List Knowledge Bases
     */
    public suspend fun listKnowledgeBases(input: ListKnowledgeBasesRequest = ListKnowledgeBasesRequest { }): ListKnowledgeBasesResponse

    /**
     * List tags for a resource
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Prepares an existing Amazon Bedrock Agent to receive runtime requests
     */
    public suspend fun prepareAgent(input: PrepareAgentRequest): PrepareAgentResponse

    /**
     * Start a new ingestion job
     */
    public suspend fun startIngestionJob(input: StartIngestionJobRequest): StartIngestionJobResponse

    /**
     * Tag a resource
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Untag a resource
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing Amazon Bedrock Agent
     */
    public suspend fun updateAgent(input: UpdateAgentRequest): UpdateAgentResponse

    /**
     * Updates an existing Action Group for Amazon Bedrock Agent
     */
    public suspend fun updateAgentActionGroup(input: UpdateAgentActionGroupRequest): UpdateAgentActionGroupResponse

    /**
     * Updates an existing Alias for an Amazon Bedrock Agent
     */
    public suspend fun updateAgentAlias(input: UpdateAgentAliasRequest): UpdateAgentAliasResponse

    /**
     * Updates an existing Knowledge Base associated to an Amazon Bedrock Agent
     */
    public suspend fun updateAgentKnowledgeBase(input: UpdateAgentKnowledgeBaseRequest): UpdateAgentKnowledgeBaseResponse

    /**
     * Update an existing data source
     */
    public suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse

    /**
     * Update an existing knowledge base
     */
    public suspend fun updateKnowledgeBase(input: UpdateKnowledgeBaseRequest): UpdateKnowledgeBaseResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun BedrockAgentClient.withConfig(block: BedrockAgentClient.Config.Builder.() -> Unit): BedrockAgentClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultBedrockAgentClient(newConfig)
}

/**
 * Associate a Knowledge Base to an existing Amazon Bedrock Agent
 */
public suspend inline fun BedrockAgentClient.associateAgentKnowledgeBase(crossinline block: AssociateAgentKnowledgeBaseRequest.Builder.() -> Unit): AssociateAgentKnowledgeBaseResponse = associateAgentKnowledgeBase(AssociateAgentKnowledgeBaseRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Bedrock Agent
 */
public suspend inline fun BedrockAgentClient.createAgent(crossinline block: CreateAgentRequest.Builder.() -> Unit): CreateAgentResponse = createAgent(CreateAgentRequest.Builder().apply(block).build())

/**
 * Creates an Action Group for existing Amazon Bedrock Agent
 */
public suspend inline fun BedrockAgentClient.createAgentActionGroup(crossinline block: CreateAgentActionGroupRequest.Builder.() -> Unit): CreateAgentActionGroupResponse = createAgentActionGroup(CreateAgentActionGroupRequest.Builder().apply(block).build())

/**
 * Creates an Alias for an existing Amazon Bedrock Agent
 */
public suspend inline fun BedrockAgentClient.createAgentAlias(crossinline block: CreateAgentAliasRequest.Builder.() -> Unit): CreateAgentAliasResponse = createAgentAlias(CreateAgentAliasRequest.Builder().apply(block).build())

/**
 * Create a new data source
 */
public suspend inline fun BedrockAgentClient.createDataSource(crossinline block: CreateDataSourceRequest.Builder.() -> Unit): CreateDataSourceResponse = createDataSource(CreateDataSourceRequest.Builder().apply(block).build())

/**
 * Create a new knowledge base
 */
public suspend inline fun BedrockAgentClient.createKnowledgeBase(crossinline block: CreateKnowledgeBaseRequest.Builder.() -> Unit): CreateKnowledgeBaseResponse = createKnowledgeBase(CreateKnowledgeBaseRequest.Builder().apply(block).build())

/**
 * Deletes an Agent for existing Amazon Bedrock Agent
 */
public suspend inline fun BedrockAgentClient.deleteAgent(crossinline block: DeleteAgentRequest.Builder.() -> Unit): DeleteAgentResponse = deleteAgent(DeleteAgentRequest.Builder().apply(block).build())

/**
 * Deletes an Action Group for existing Amazon Bedrock Agent.
 */
public suspend inline fun BedrockAgentClient.deleteAgentActionGroup(crossinline block: DeleteAgentActionGroupRequest.Builder.() -> Unit): DeleteAgentActionGroupResponse = deleteAgentActionGroup(DeleteAgentActionGroupRequest.Builder().apply(block).build())

/**
 * Deletes an Alias for a Amazon Bedrock Agent
 */
public suspend inline fun BedrockAgentClient.deleteAgentAlias(crossinline block: DeleteAgentAliasRequest.Builder.() -> Unit): DeleteAgentAliasResponse = deleteAgentAlias(DeleteAgentAliasRequest.Builder().apply(block).build())

/**
 * Deletes an Agent version for existing Amazon Bedrock Agent
 */
public suspend inline fun BedrockAgentClient.deleteAgentVersion(crossinline block: DeleteAgentVersionRequest.Builder.() -> Unit): DeleteAgentVersionResponse = deleteAgentVersion(DeleteAgentVersionRequest.Builder().apply(block).build())

/**
 * Delete an existing data source
 */
public suspend inline fun BedrockAgentClient.deleteDataSource(crossinline block: DeleteDataSourceRequest.Builder.() -> Unit): DeleteDataSourceResponse = deleteDataSource(DeleteDataSourceRequest.Builder().apply(block).build())

/**
 * Delete an existing knowledge base
 */
public suspend inline fun BedrockAgentClient.deleteKnowledgeBase(crossinline block: DeleteKnowledgeBaseRequest.Builder.() -> Unit): DeleteKnowledgeBaseResponse = deleteKnowledgeBase(DeleteKnowledgeBaseRequest.Builder().apply(block).build())

/**
 * Disassociate an existing Knowledge Base from an Amazon Bedrock Agent
 */
public suspend inline fun BedrockAgentClient.disassociateAgentKnowledgeBase(crossinline block: DisassociateAgentKnowledgeBaseRequest.Builder.() -> Unit): DisassociateAgentKnowledgeBaseResponse = disassociateAgentKnowledgeBase(DisassociateAgentKnowledgeBaseRequest.Builder().apply(block).build())

/**
 * Gets an Agent for existing Amazon Bedrock Agent
 */
public suspend inline fun BedrockAgentClient.getAgent(crossinline block: GetAgentRequest.Builder.() -> Unit): GetAgentResponse = getAgent(GetAgentRequest.Builder().apply(block).build())

/**
 * Gets an Action Group for existing Amazon Bedrock Agent Version
 */
public suspend inline fun BedrockAgentClient.getAgentActionGroup(crossinline block: GetAgentActionGroupRequest.Builder.() -> Unit): GetAgentActionGroupResponse = getAgentActionGroup(GetAgentActionGroupRequest.Builder().apply(block).build())

/**
 * Describes an Alias for a Amazon Bedrock Agent
 */
public suspend inline fun BedrockAgentClient.getAgentAlias(crossinline block: GetAgentAliasRequest.Builder.() -> Unit): GetAgentAliasResponse = getAgentAlias(GetAgentAliasRequest.Builder().apply(block).build())

/**
 * Gets a knowledge base associated to an existing Amazon Bedrock Agent Version
 */
public suspend inline fun BedrockAgentClient.getAgentKnowledgeBase(crossinline block: GetAgentKnowledgeBaseRequest.Builder.() -> Unit): GetAgentKnowledgeBaseResponse = getAgentKnowledgeBase(GetAgentKnowledgeBaseRequest.Builder().apply(block).build())

/**
 * Gets an Agent version for existing Amazon Bedrock Agent
 */
public suspend inline fun BedrockAgentClient.getAgentVersion(crossinline block: GetAgentVersionRequest.Builder.() -> Unit): GetAgentVersionResponse = getAgentVersion(GetAgentVersionRequest.Builder().apply(block).build())

/**
 * Get an existing data source
 */
public suspend inline fun BedrockAgentClient.getDataSource(crossinline block: GetDataSourceRequest.Builder.() -> Unit): GetDataSourceResponse = getDataSource(GetDataSourceRequest.Builder().apply(block).build())

/**
 * Get an ingestion job
 */
public suspend inline fun BedrockAgentClient.getIngestionJob(crossinline block: GetIngestionJobRequest.Builder.() -> Unit): GetIngestionJobResponse = getIngestionJob(GetIngestionJobRequest.Builder().apply(block).build())

/**
 * Get an existing knowledge base
 */
public suspend inline fun BedrockAgentClient.getKnowledgeBase(crossinline block: GetKnowledgeBaseRequest.Builder.() -> Unit): GetKnowledgeBaseResponse = getKnowledgeBase(GetKnowledgeBaseRequest.Builder().apply(block).build())

/**
 * Lists an Action Group for existing Amazon Bedrock Agent Version
 */
public suspend inline fun BedrockAgentClient.listAgentActionGroups(crossinline block: ListAgentActionGroupsRequest.Builder.() -> Unit): ListAgentActionGroupsResponse = listAgentActionGroups(ListAgentActionGroupsRequest.Builder().apply(block).build())

/**
 * Lists all the Aliases for an Amazon Bedrock Agent
 */
public suspend inline fun BedrockAgentClient.listAgentAliases(crossinline block: ListAgentAliasesRequest.Builder.() -> Unit): ListAgentAliasesResponse = listAgentAliases(ListAgentAliasesRequest.Builder().apply(block).build())

/**
 * List of Knowledge Bases associated to an existing Amazon Bedrock Agent Version
 */
public suspend inline fun BedrockAgentClient.listAgentKnowledgeBases(crossinline block: ListAgentKnowledgeBasesRequest.Builder.() -> Unit): ListAgentKnowledgeBasesResponse = listAgentKnowledgeBases(ListAgentKnowledgeBasesRequest.Builder().apply(block).build())

/**
 * Lists Agent Versions
 */
public suspend inline fun BedrockAgentClient.listAgentVersions(crossinline block: ListAgentVersionsRequest.Builder.() -> Unit): ListAgentVersionsResponse = listAgentVersions(ListAgentVersionsRequest.Builder().apply(block).build())

/**
 * Lists Agents
 */
public suspend inline fun BedrockAgentClient.listAgents(crossinline block: ListAgentsRequest.Builder.() -> Unit): ListAgentsResponse = listAgents(ListAgentsRequest.Builder().apply(block).build())

/**
 * List data sources
 */
public suspend inline fun BedrockAgentClient.listDataSources(crossinline block: ListDataSourcesRequest.Builder.() -> Unit): ListDataSourcesResponse = listDataSources(ListDataSourcesRequest.Builder().apply(block).build())

/**
 * List ingestion jobs
 */
public suspend inline fun BedrockAgentClient.listIngestionJobs(crossinline block: ListIngestionJobsRequest.Builder.() -> Unit): ListIngestionJobsResponse = listIngestionJobs(ListIngestionJobsRequest.Builder().apply(block).build())

/**
 * List Knowledge Bases
 */
public suspend inline fun BedrockAgentClient.listKnowledgeBases(crossinline block: ListKnowledgeBasesRequest.Builder.() -> Unit): ListKnowledgeBasesResponse = listKnowledgeBases(ListKnowledgeBasesRequest.Builder().apply(block).build())

/**
 * List tags for a resource
 */
public suspend inline fun BedrockAgentClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Prepares an existing Amazon Bedrock Agent to receive runtime requests
 */
public suspend inline fun BedrockAgentClient.prepareAgent(crossinline block: PrepareAgentRequest.Builder.() -> Unit): PrepareAgentResponse = prepareAgent(PrepareAgentRequest.Builder().apply(block).build())

/**
 * Start a new ingestion job
 */
public suspend inline fun BedrockAgentClient.startIngestionJob(crossinline block: StartIngestionJobRequest.Builder.() -> Unit): StartIngestionJobResponse = startIngestionJob(StartIngestionJobRequest.Builder().apply(block).build())

/**
 * Tag a resource
 */
public suspend inline fun BedrockAgentClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Untag a resource
 */
public suspend inline fun BedrockAgentClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing Amazon Bedrock Agent
 */
public suspend inline fun BedrockAgentClient.updateAgent(crossinline block: UpdateAgentRequest.Builder.() -> Unit): UpdateAgentResponse = updateAgent(UpdateAgentRequest.Builder().apply(block).build())

/**
 * Updates an existing Action Group for Amazon Bedrock Agent
 */
public suspend inline fun BedrockAgentClient.updateAgentActionGroup(crossinline block: UpdateAgentActionGroupRequest.Builder.() -> Unit): UpdateAgentActionGroupResponse = updateAgentActionGroup(UpdateAgentActionGroupRequest.Builder().apply(block).build())

/**
 * Updates an existing Alias for an Amazon Bedrock Agent
 */
public suspend inline fun BedrockAgentClient.updateAgentAlias(crossinline block: UpdateAgentAliasRequest.Builder.() -> Unit): UpdateAgentAliasResponse = updateAgentAlias(UpdateAgentAliasRequest.Builder().apply(block).build())

/**
 * Updates an existing Knowledge Base associated to an Amazon Bedrock Agent
 */
public suspend inline fun BedrockAgentClient.updateAgentKnowledgeBase(crossinline block: UpdateAgentKnowledgeBaseRequest.Builder.() -> Unit): UpdateAgentKnowledgeBaseResponse = updateAgentKnowledgeBase(UpdateAgentKnowledgeBaseRequest.Builder().apply(block).build())

/**
 * Update an existing data source
 */
public suspend inline fun BedrockAgentClient.updateDataSource(crossinline block: UpdateDataSourceRequest.Builder.() -> Unit): UpdateDataSourceResponse = updateDataSource(UpdateDataSourceRequest.Builder().apply(block).build())

/**
 * Update an existing knowledge base
 */
public suspend inline fun BedrockAgentClient.updateKnowledgeBase(crossinline block: UpdateKnowledgeBaseRequest.Builder.() -> Unit): UpdateKnowledgeBaseResponse = updateKnowledgeBase(UpdateKnowledgeBaseRequest.Builder().apply(block).build())
