// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.serde

import aws.sdk.kotlin.services.bedrock.model.GuardrailContentPolicyConfig
import aws.sdk.kotlin.services.bedrock.model.GuardrailContextualGroundingPolicyConfig
import aws.sdk.kotlin.services.bedrock.model.GuardrailSensitiveInformationPolicyConfig
import aws.sdk.kotlin.services.bedrock.model.GuardrailTopicPolicyConfig
import aws.sdk.kotlin.services.bedrock.model.GuardrailWordPolicyConfig
import aws.sdk.kotlin.services.bedrock.model.UpdateGuardrailRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateGuardrailOperationSerializer: HttpSerializer.NonStreaming<UpdateGuardrailRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateGuardrailRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.guardrailIdentifier) { "guardrailIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("guardrails"))
                add(PercentEncoding.SmithyLabel.encode(input.guardrailIdentifier))
            }
        }

        val payload = serializeUpdateGuardrailOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateGuardrailOperationBody(context: ExecutionContext, input: UpdateGuardrailRequest): ByteArray {
    val serializer = JsonSerializer()
    val BLOCKEDINPUTMESSAGING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("blockedInputMessaging"))
    val BLOCKEDOUTPUTSMESSAGING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("blockedOutputsMessaging"))
    val CONTENTPOLICYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("contentPolicyConfig"))
    val CONTEXTUALGROUNDINGPOLICYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("contextualGroundingPolicyConfig"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyId"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val SENSITIVEINFORMATIONPOLICYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sensitiveInformationPolicyConfig"))
    val TOPICPOLICYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("topicPolicyConfig"))
    val WORDPOLICYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("wordPolicyConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BLOCKEDINPUTMESSAGING_DESCRIPTOR)
        field(BLOCKEDOUTPUTSMESSAGING_DESCRIPTOR)
        field(CONTENTPOLICYCONFIG_DESCRIPTOR)
        field(CONTEXTUALGROUNDINGPOLICYCONFIG_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SENSITIVEINFORMATIONPOLICYCONFIG_DESCRIPTOR)
        field(TOPICPOLICYCONFIG_DESCRIPTOR)
        field(WORDPOLICYCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.blockedInputMessaging?.let { field(BLOCKEDINPUTMESSAGING_DESCRIPTOR, it) }
        input.blockedOutputsMessaging?.let { field(BLOCKEDOUTPUTSMESSAGING_DESCRIPTOR, it) }
        input.contentPolicyConfig?.let { field(CONTENTPOLICYCONFIG_DESCRIPTOR, it, ::serializeGuardrailContentPolicyConfigDocument) }
        input.contextualGroundingPolicyConfig?.let { field(CONTEXTUALGROUNDINGPOLICYCONFIG_DESCRIPTOR, it, ::serializeGuardrailContextualGroundingPolicyConfigDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.sensitiveInformationPolicyConfig?.let { field(SENSITIVEINFORMATIONPOLICYCONFIG_DESCRIPTOR, it, ::serializeGuardrailSensitiveInformationPolicyConfigDocument) }
        input.topicPolicyConfig?.let { field(TOPICPOLICYCONFIG_DESCRIPTOR, it, ::serializeGuardrailTopicPolicyConfigDocument) }
        input.wordPolicyConfig?.let { field(WORDPOLICYCONFIG_DESCRIPTOR, it, ::serializeGuardrailWordPolicyConfigDocument) }
    }
    return serializer.toByteArray()
}
