// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.serde

import aws.sdk.kotlin.services.bedrock.model.BedrockException
import aws.sdk.kotlin.services.bedrock.model.GetModelInvocationJobResponse
import aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobInputDataConfig
import aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobOutputDataConfig
import aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobStatus
import aws.sdk.kotlin.services.bedrock.model.VpcConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetModelInvocationJobOperationDeserializer: HttpDeserializer.NonStreaming<GetModelInvocationJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetModelInvocationJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetModelInvocationJobError(context, call, payload)
        }
        val builder = GetModelInvocationJobResponse.Builder()

        if (payload != null) {
            deserializeGetModelInvocationJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetModelInvocationJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BedrockException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BedrockException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetModelInvocationJobOperationBody(builder: GetModelInvocationJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endTime"))
    val INPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("inputDataConfig"))
    val JOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobArn"))
    val JOBEXPIRATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("jobExpirationTime"))
    val JOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobName"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedTime"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("message"))
    val MODELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("modelId"))
    val OUTPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("outputDataConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val SUBMITTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("submitTime"))
    val TIMEOUTDURATIONINHOURS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("timeoutDurationInHours"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(INPUTDATACONFIG_DESCRIPTOR)
        field(JOBARN_DESCRIPTOR)
        field(JOBEXPIRATIONTIME_DESCRIPTOR)
        field(JOBNAME_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(MODELID_DESCRIPTOR)
        field(OUTPUTDATACONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(SUBMITTIME_DESCRIPTOR)
        field(TIMEOUTDURATIONINHOURS_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLIENTREQUESTTOKEN_DESCRIPTOR.index -> builder.clientRequestToken = deserializeString()
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeInstant(TimestampFormat.ISO_8601)
                INPUTDATACONFIG_DESCRIPTOR.index -> builder.inputDataConfig = deserializeModelInvocationJobInputDataConfigDocument(deserializer)
                JOBARN_DESCRIPTOR.index -> builder.jobArn = deserializeString()
                JOBEXPIRATIONTIME_DESCRIPTOR.index -> builder.jobExpirationTime = deserializeInstant(TimestampFormat.ISO_8601)
                JOBNAME_DESCRIPTOR.index -> builder.jobName = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.ISO_8601)
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                MODELID_DESCRIPTOR.index -> builder.modelId = deserializeString()
                OUTPUTDATACONFIG_DESCRIPTOR.index -> builder.outputDataConfig = deserializeModelInvocationJobOutputDataConfigDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ModelInvocationJobStatus.fromValue(it) }
                SUBMITTIME_DESCRIPTOR.index -> builder.submitTime = deserializeInstant(TimestampFormat.ISO_8601)
                TIMEOUTDURATIONINHOURS_DESCRIPTOR.index -> builder.timeoutDurationInHours = deserializeInt()
                VPCCONFIG_DESCRIPTOR.index -> builder.vpcConfig = deserializeVpcConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
