// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.serde

import aws.sdk.kotlin.services.bedrock.model.BedrockException
import aws.sdk.kotlin.services.bedrock.model.GetModelImportJobResponse
import aws.sdk.kotlin.services.bedrock.model.ModelDataSource
import aws.sdk.kotlin.services.bedrock.model.ModelImportJobStatus
import aws.sdk.kotlin.services.bedrock.model.VpcConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetModelImportJobOperationDeserializer: HttpDeserializer.NonStreaming<GetModelImportJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetModelImportJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetModelImportJobError(context, call, payload)
        }
        val builder = GetModelImportJobResponse.Builder()

        if (payload != null) {
            deserializeGetModelImportJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetModelImportJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BedrockException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BedrockException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetModelImportJobOperationBody(builder: GetModelImportJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endTime"))
    val FAILUREMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureMessage"))
    val IMPORTEDMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("importedModelArn"))
    val IMPORTEDMODELKMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("importedModelKmsKeyArn"))
    val IMPORTEDMODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("importedModelName"))
    val JOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobArn"))
    val JOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobName"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedTime"))
    val MODELDATASOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("modelDataSource"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(FAILUREMESSAGE_DESCRIPTOR)
        field(IMPORTEDMODELARN_DESCRIPTOR)
        field(IMPORTEDMODELKMSKEYARN_DESCRIPTOR)
        field(IMPORTEDMODELNAME_DESCRIPTOR)
        field(JOBARN_DESCRIPTOR)
        field(JOBNAME_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(MODELDATASOURCE_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.ISO_8601)
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeInstant(TimestampFormat.ISO_8601)
                FAILUREMESSAGE_DESCRIPTOR.index -> builder.failureMessage = deserializeString()
                IMPORTEDMODELARN_DESCRIPTOR.index -> builder.importedModelArn = deserializeString()
                IMPORTEDMODELKMSKEYARN_DESCRIPTOR.index -> builder.importedModelKmsKeyArn = deserializeString()
                IMPORTEDMODELNAME_DESCRIPTOR.index -> builder.importedModelName = deserializeString()
                JOBARN_DESCRIPTOR.index -> builder.jobArn = deserializeString()
                JOBNAME_DESCRIPTOR.index -> builder.jobName = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.ISO_8601)
                MODELDATASOURCE_DESCRIPTOR.index -> builder.modelDataSource = deserializeModelDataSourceDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ModelImportJobStatus.fromValue(it) }
                VPCCONFIG_DESCRIPTOR.index -> builder.vpcConfig = deserializeVpcConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
