// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.serde

import aws.sdk.kotlin.services.bedrock.model.BedrockException
import aws.sdk.kotlin.services.bedrock.model.CustomizationType
import aws.sdk.kotlin.services.bedrock.model.GetModelCustomizationJobResponse
import aws.sdk.kotlin.services.bedrock.model.ModelCustomizationJobStatus
import aws.sdk.kotlin.services.bedrock.model.OutputDataConfig
import aws.sdk.kotlin.services.bedrock.model.TrainingDataConfig
import aws.sdk.kotlin.services.bedrock.model.TrainingMetrics
import aws.sdk.kotlin.services.bedrock.model.ValidationDataConfig
import aws.sdk.kotlin.services.bedrock.model.ValidatorMetric
import aws.sdk.kotlin.services.bedrock.model.VpcConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetModelCustomizationJobOperationDeserializer: HttpDeserializer.NonStreaming<GetModelCustomizationJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetModelCustomizationJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetModelCustomizationJobError(context, call, payload)
        }
        val builder = GetModelCustomizationJobResponse.Builder()

        if (payload != null) {
            deserializeGetModelCustomizationJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetModelCustomizationJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BedrockException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BedrockException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetModelCustomizationJobOperationBody(builder: GetModelCustomizationJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASEMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("baseModelArn"))
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val CUSTOMIZATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("customizationType"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endTime"))
    val FAILUREMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureMessage"))
    val HYPERPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("hyperParameters"))
    val JOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobArn"))
    val JOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobName"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedTime"))
    val OUTPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("outputDataConfig"))
    val OUTPUTMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("outputModelArn"))
    val OUTPUTMODELKMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("outputModelKmsKeyArn"))
    val OUTPUTMODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("outputModelName"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val TRAININGDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("trainingDataConfig"))
    val TRAININGMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("trainingMetrics"))
    val VALIDATIONDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("validationDataConfig"))
    val VALIDATIONMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("validationMetrics"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASEMODELARN_DESCRIPTOR)
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(CUSTOMIZATIONTYPE_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(FAILUREMESSAGE_DESCRIPTOR)
        field(HYPERPARAMETERS_DESCRIPTOR)
        field(JOBARN_DESCRIPTOR)
        field(JOBNAME_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(OUTPUTDATACONFIG_DESCRIPTOR)
        field(OUTPUTMODELARN_DESCRIPTOR)
        field(OUTPUTMODELKMSKEYARN_DESCRIPTOR)
        field(OUTPUTMODELNAME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TRAININGDATACONFIG_DESCRIPTOR)
        field(TRAININGMETRICS_DESCRIPTOR)
        field(VALIDATIONDATACONFIG_DESCRIPTOR)
        field(VALIDATIONMETRICS_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASEMODELARN_DESCRIPTOR.index -> builder.baseModelArn = deserializeString()
                CLIENTREQUESTTOKEN_DESCRIPTOR.index -> builder.clientRequestToken = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.ISO_8601)
                CUSTOMIZATIONTYPE_DESCRIPTOR.index -> builder.customizationType = deserializeString().let { CustomizationType.fromValue(it) }
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeInstant(TimestampFormat.ISO_8601)
                FAILUREMESSAGE_DESCRIPTOR.index -> builder.failureMessage = deserializeString()
                HYPERPARAMETERS_DESCRIPTOR.index -> builder.hyperParameters =
                    deserializer.deserializeMap(HYPERPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                JOBARN_DESCRIPTOR.index -> builder.jobArn = deserializeString()
                JOBNAME_DESCRIPTOR.index -> builder.jobName = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.ISO_8601)
                OUTPUTDATACONFIG_DESCRIPTOR.index -> builder.outputDataConfig = deserializeOutputDataConfigDocument(deserializer)
                OUTPUTMODELARN_DESCRIPTOR.index -> builder.outputModelArn = deserializeString()
                OUTPUTMODELKMSKEYARN_DESCRIPTOR.index -> builder.outputModelKmsKeyArn = deserializeString()
                OUTPUTMODELNAME_DESCRIPTOR.index -> builder.outputModelName = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ModelCustomizationJobStatus.fromValue(it) }
                TRAININGDATACONFIG_DESCRIPTOR.index -> builder.trainingDataConfig = deserializeTrainingDataConfigDocument(deserializer)
                TRAININGMETRICS_DESCRIPTOR.index -> builder.trainingMetrics = deserializeTrainingMetricsDocument(deserializer)
                VALIDATIONDATACONFIG_DESCRIPTOR.index -> builder.validationDataConfig = deserializeValidationDataConfigDocument(deserializer)
                VALIDATIONMETRICS_DESCRIPTOR.index -> builder.validationMetrics =
                    deserializer.deserializeList(VALIDATIONMETRICS_DESCRIPTOR) {
                        val col0 = mutableListOf<ValidatorMetric>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeValidatorMetricDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VPCCONFIG_DESCRIPTOR.index -> builder.vpcConfig = deserializeVpcConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
