// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.serde

import aws.sdk.kotlin.services.bedrock.model.BedrockException
import aws.sdk.kotlin.services.bedrock.model.GetModelCopyJobResponse
import aws.sdk.kotlin.services.bedrock.model.ModelCopyJobStatus
import aws.sdk.kotlin.services.bedrock.model.Tag
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetModelCopyJobOperationDeserializer: HttpDeserializer.NonStreaming<GetModelCopyJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetModelCopyJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetModelCopyJobError(context, call, payload)
        }
        val builder = GetModelCopyJobResponse.Builder()

        if (payload != null) {
            deserializeGetModelCopyJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetModelCopyJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BedrockException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BedrockException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetModelCopyJobOperationBody(builder: GetModelCopyJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val FAILUREMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureMessage"))
    val JOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobArn"))
    val SOURCEACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceAccountId"))
    val SOURCEMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceModelArn"))
    val SOURCEMODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceModelName"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val TARGETMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("targetModelArn"))
    val TARGETMODELKMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("targetModelKmsKeyArn"))
    val TARGETMODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("targetModelName"))
    val TARGETMODELTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("targetModelTags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(FAILUREMESSAGE_DESCRIPTOR)
        field(JOBARN_DESCRIPTOR)
        field(SOURCEACCOUNTID_DESCRIPTOR)
        field(SOURCEMODELARN_DESCRIPTOR)
        field(SOURCEMODELNAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TARGETMODELARN_DESCRIPTOR)
        field(TARGETMODELKMSKEYARN_DESCRIPTOR)
        field(TARGETMODELNAME_DESCRIPTOR)
        field(TARGETMODELTAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.ISO_8601)
                FAILUREMESSAGE_DESCRIPTOR.index -> builder.failureMessage = deserializeString()
                JOBARN_DESCRIPTOR.index -> builder.jobArn = deserializeString()
                SOURCEACCOUNTID_DESCRIPTOR.index -> builder.sourceAccountId = deserializeString()
                SOURCEMODELARN_DESCRIPTOR.index -> builder.sourceModelArn = deserializeString()
                SOURCEMODELNAME_DESCRIPTOR.index -> builder.sourceModelName = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ModelCopyJobStatus.fromValue(it) }
                TARGETMODELARN_DESCRIPTOR.index -> builder.targetModelArn = deserializeString()
                TARGETMODELKMSKEYARN_DESCRIPTOR.index -> builder.targetModelKmsKeyArn = deserializeString()
                TARGETMODELNAME_DESCRIPTOR.index -> builder.targetModelName = deserializeString()
                TARGETMODELTAGS_DESCRIPTOR.index -> builder.targetModelTags =
                    deserializer.deserializeList(TARGETMODELTAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
