// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.serde

import aws.sdk.kotlin.services.bedrock.model.BedrockException
import aws.sdk.kotlin.services.bedrock.model.GetImportedModelResponse
import aws.sdk.kotlin.services.bedrock.model.ModelDataSource
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetImportedModelOperationDeserializer: HttpDeserializer.NonStreaming<GetImportedModelResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetImportedModelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetImportedModelError(context, call, payload)
        }
        val builder = GetImportedModelResponse.Builder()

        if (payload != null) {
            deserializeGetImportedModelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetImportedModelError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BedrockException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BedrockException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetImportedModelOperationBody(builder: GetImportedModelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val INSTRUCTSUPPORTED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("instructSupported"))
    val JOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobArn"))
    val JOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobName"))
    val MODELARCHITECTURE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("modelArchitecture"))
    val MODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("modelArn"))
    val MODELDATASOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("modelDataSource"))
    val MODELKMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("modelKmsKeyArn"))
    val MODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("modelName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(INSTRUCTSUPPORTED_DESCRIPTOR)
        field(JOBARN_DESCRIPTOR)
        field(JOBNAME_DESCRIPTOR)
        field(MODELARCHITECTURE_DESCRIPTOR)
        field(MODELARN_DESCRIPTOR)
        field(MODELDATASOURCE_DESCRIPTOR)
        field(MODELKMSKEYARN_DESCRIPTOR)
        field(MODELNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.ISO_8601)
                INSTRUCTSUPPORTED_DESCRIPTOR.index -> builder.instructSupported = deserializeBoolean()
                JOBARN_DESCRIPTOR.index -> builder.jobArn = deserializeString()
                JOBNAME_DESCRIPTOR.index -> builder.jobName = deserializeString()
                MODELARCHITECTURE_DESCRIPTOR.index -> builder.modelArchitecture = deserializeString()
                MODELARN_DESCRIPTOR.index -> builder.modelArn = deserializeString()
                MODELDATASOURCE_DESCRIPTOR.index -> builder.modelDataSource = deserializeModelDataSourceDocument(deserializer)
                MODELKMSKEYARN_DESCRIPTOR.index -> builder.modelKmsKeyArn = deserializeString()
                MODELNAME_DESCRIPTOR.index -> builder.modelName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
