// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.serde

import aws.sdk.kotlin.services.bedrock.model.BedrockException
import aws.sdk.kotlin.services.bedrock.model.GetGuardrailResponse
import aws.sdk.kotlin.services.bedrock.model.GuardrailContentPolicy
import aws.sdk.kotlin.services.bedrock.model.GuardrailContextualGroundingPolicy
import aws.sdk.kotlin.services.bedrock.model.GuardrailSensitiveInformationPolicy
import aws.sdk.kotlin.services.bedrock.model.GuardrailStatus
import aws.sdk.kotlin.services.bedrock.model.GuardrailTopicPolicy
import aws.sdk.kotlin.services.bedrock.model.GuardrailWordPolicy
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetGuardrailOperationDeserializer: HttpDeserializer.NonStreaming<GetGuardrailResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetGuardrailResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetGuardrailError(context, call, payload)
        }
        val builder = GetGuardrailResponse.Builder()

        if (payload != null) {
            deserializeGetGuardrailOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetGuardrailError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BedrockException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BedrockException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetGuardrailOperationBody(builder: GetGuardrailResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BLOCKEDINPUTMESSAGING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("blockedInputMessaging"))
    val BLOCKEDOUTPUTSMESSAGING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("blockedOutputsMessaging"))
    val CONTENTPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("contentPolicy"))
    val CONTEXTUALGROUNDINGPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("contextualGroundingPolicy"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val FAILURERECOMMENDATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failureRecommendations"))
    val GUARDRAILARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("guardrailArn"))
    val GUARDRAILID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("guardrailId"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyArn"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val SENSITIVEINFORMATIONPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sensitiveInformationPolicy"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STATUSREASONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("statusReasons"))
    val TOPICPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("topicPolicy"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("version"))
    val WORDPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("wordPolicy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BLOCKEDINPUTMESSAGING_DESCRIPTOR)
        field(BLOCKEDOUTPUTSMESSAGING_DESCRIPTOR)
        field(CONTENTPOLICY_DESCRIPTOR)
        field(CONTEXTUALGROUNDINGPOLICY_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FAILURERECOMMENDATIONS_DESCRIPTOR)
        field(GUARDRAILARN_DESCRIPTOR)
        field(GUARDRAILID_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SENSITIVEINFORMATIONPOLICY_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASONS_DESCRIPTOR)
        field(TOPICPOLICY_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
        field(WORDPOLICY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BLOCKEDINPUTMESSAGING_DESCRIPTOR.index -> builder.blockedInputMessaging = deserializeString()
                BLOCKEDOUTPUTSMESSAGING_DESCRIPTOR.index -> builder.blockedOutputsMessaging = deserializeString()
                CONTENTPOLICY_DESCRIPTOR.index -> builder.contentPolicy = deserializeGuardrailContentPolicyDocument(deserializer)
                CONTEXTUALGROUNDINGPOLICY_DESCRIPTOR.index -> builder.contextualGroundingPolicy = deserializeGuardrailContextualGroundingPolicyDocument(deserializer)
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.ISO_8601)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                FAILURERECOMMENDATIONS_DESCRIPTOR.index -> builder.failureRecommendations =
                    deserializer.deserializeList(FAILURERECOMMENDATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                GUARDRAILARN_DESCRIPTOR.index -> builder.guardrailArn = deserializeString()
                GUARDRAILID_DESCRIPTOR.index -> builder.guardrailId = deserializeString()
                KMSKEYARN_DESCRIPTOR.index -> builder.kmsKeyArn = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SENSITIVEINFORMATIONPOLICY_DESCRIPTOR.index -> builder.sensitiveInformationPolicy = deserializeGuardrailSensitiveInformationPolicyDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { GuardrailStatus.fromValue(it) }
                STATUSREASONS_DESCRIPTOR.index -> builder.statusReasons =
                    deserializer.deserializeList(STATUSREASONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TOPICPOLICY_DESCRIPTOR.index -> builder.topicPolicy = deserializeGuardrailTopicPolicyDocument(deserializer)
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeInstant(TimestampFormat.ISO_8601)
                VERSION_DESCRIPTOR.index -> builder.version = deserializeString()
                WORDPOLICY_DESCRIPTOR.index -> builder.wordPolicy = deserializeGuardrailWordPolicyDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
