// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.serde

import aws.sdk.kotlin.services.bedrock.model.BedrockException
import aws.sdk.kotlin.services.bedrock.model.EvaluationConfig
import aws.sdk.kotlin.services.bedrock.model.EvaluationInferenceConfig
import aws.sdk.kotlin.services.bedrock.model.EvaluationJobStatus
import aws.sdk.kotlin.services.bedrock.model.EvaluationJobType
import aws.sdk.kotlin.services.bedrock.model.EvaluationOutputDataConfig
import aws.sdk.kotlin.services.bedrock.model.GetEvaluationJobResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetEvaluationJobOperationDeserializer: HttpDeserializer.NonStreaming<GetEvaluationJobResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetEvaluationJobResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetEvaluationJobError(context, call, payload)
        }
        val builder = GetEvaluationJobResponse.Builder()

        if (payload != null) {
            deserializeGetEvaluationJobOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetEvaluationJobError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BedrockException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BedrockException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEvaluationJobOperationBody(builder: GetEvaluationJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val CUSTOMERENCRYPTIONKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customerEncryptionKeyId"))
    val EVALUATIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("evaluationConfig"))
    val FAILUREMESSAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failureMessages"))
    val INFERENCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("inferenceConfig"))
    val JOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobArn"))
    val JOBDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobDescription"))
    val JOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobName"))
    val JOBTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("jobType"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedTime"))
    val OUTPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("outputDataConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(CUSTOMERENCRYPTIONKEYID_DESCRIPTOR)
        field(EVALUATIONCONFIG_DESCRIPTOR)
        field(FAILUREMESSAGES_DESCRIPTOR)
        field(INFERENCECONFIG_DESCRIPTOR)
        field(JOBARN_DESCRIPTOR)
        field(JOBDESCRIPTION_DESCRIPTOR)
        field(JOBNAME_DESCRIPTOR)
        field(JOBTYPE_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(OUTPUTDATACONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.ISO_8601)
                CUSTOMERENCRYPTIONKEYID_DESCRIPTOR.index -> builder.customerEncryptionKeyId = deserializeString()
                EVALUATIONCONFIG_DESCRIPTOR.index -> builder.evaluationConfig = deserializeEvaluationConfigDocument(deserializer)
                FAILUREMESSAGES_DESCRIPTOR.index -> builder.failureMessages =
                    deserializer.deserializeList(FAILUREMESSAGES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INFERENCECONFIG_DESCRIPTOR.index -> builder.inferenceConfig = deserializeEvaluationInferenceConfigDocument(deserializer)
                JOBARN_DESCRIPTOR.index -> builder.jobArn = deserializeString()
                JOBDESCRIPTION_DESCRIPTOR.index -> builder.jobDescription = deserializeString()
                JOBNAME_DESCRIPTOR.index -> builder.jobName = deserializeString()
                JOBTYPE_DESCRIPTOR.index -> builder.jobType = deserializeString().let { EvaluationJobType.fromValue(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.ISO_8601)
                OUTPUTDATACONFIG_DESCRIPTOR.index -> builder.outputDataConfig = deserializeEvaluationOutputDataConfigDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { EvaluationJobStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
