// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.serde

import aws.sdk.kotlin.services.bedrock.model.BedrockException
import aws.sdk.kotlin.services.bedrock.model.CustomizationType
import aws.sdk.kotlin.services.bedrock.model.GetCustomModelResponse
import aws.sdk.kotlin.services.bedrock.model.OutputDataConfig
import aws.sdk.kotlin.services.bedrock.model.TrainingDataConfig
import aws.sdk.kotlin.services.bedrock.model.TrainingMetrics
import aws.sdk.kotlin.services.bedrock.model.ValidationDataConfig
import aws.sdk.kotlin.services.bedrock.model.ValidatorMetric
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetCustomModelOperationDeserializer: HttpDeserializer.NonStreaming<GetCustomModelResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetCustomModelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetCustomModelError(context, call, payload)
        }
        val builder = GetCustomModelResponse.Builder()

        if (payload != null) {
            deserializeGetCustomModelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetCustomModelError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BedrockException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BedrockException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCustomModelOperationBody(builder: GetCustomModelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASEMODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("baseModelArn"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val CUSTOMIZATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("customizationType"))
    val HYPERPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("hyperParameters"))
    val JOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobArn"))
    val JOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobName"))
    val MODELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("modelArn"))
    val MODELKMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("modelKmsKeyArn"))
    val MODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("modelName"))
    val OUTPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("outputDataConfig"))
    val TRAININGDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("trainingDataConfig"))
    val TRAININGMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("trainingMetrics"))
    val VALIDATIONDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("validationDataConfig"))
    val VALIDATIONMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("validationMetrics"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASEMODELARN_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(CUSTOMIZATIONTYPE_DESCRIPTOR)
        field(HYPERPARAMETERS_DESCRIPTOR)
        field(JOBARN_DESCRIPTOR)
        field(JOBNAME_DESCRIPTOR)
        field(MODELARN_DESCRIPTOR)
        field(MODELKMSKEYARN_DESCRIPTOR)
        field(MODELNAME_DESCRIPTOR)
        field(OUTPUTDATACONFIG_DESCRIPTOR)
        field(TRAININGDATACONFIG_DESCRIPTOR)
        field(TRAININGMETRICS_DESCRIPTOR)
        field(VALIDATIONDATACONFIG_DESCRIPTOR)
        field(VALIDATIONMETRICS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASEMODELARN_DESCRIPTOR.index -> builder.baseModelArn = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.ISO_8601)
                CUSTOMIZATIONTYPE_DESCRIPTOR.index -> builder.customizationType = deserializeString().let { CustomizationType.fromValue(it) }
                HYPERPARAMETERS_DESCRIPTOR.index -> builder.hyperParameters =
                    deserializer.deserializeMap(HYPERPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                JOBARN_DESCRIPTOR.index -> builder.jobArn = deserializeString()
                JOBNAME_DESCRIPTOR.index -> builder.jobName = deserializeString()
                MODELARN_DESCRIPTOR.index -> builder.modelArn = deserializeString()
                MODELKMSKEYARN_DESCRIPTOR.index -> builder.modelKmsKeyArn = deserializeString()
                MODELNAME_DESCRIPTOR.index -> builder.modelName = deserializeString()
                OUTPUTDATACONFIG_DESCRIPTOR.index -> builder.outputDataConfig = deserializeOutputDataConfigDocument(deserializer)
                TRAININGDATACONFIG_DESCRIPTOR.index -> builder.trainingDataConfig = deserializeTrainingDataConfigDocument(deserializer)
                TRAININGMETRICS_DESCRIPTOR.index -> builder.trainingMetrics = deserializeTrainingMetricsDocument(deserializer)
                VALIDATIONDATACONFIG_DESCRIPTOR.index -> builder.validationDataConfig = deserializeValidationDataConfigDocument(deserializer)
                VALIDATIONMETRICS_DESCRIPTOR.index -> builder.validationMetrics =
                    deserializer.deserializeList(VALIDATIONMETRICS_DESCRIPTOR) {
                        val col0 = mutableListOf<ValidatorMetric>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeValidatorMetricDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
