// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.serde

import aws.sdk.kotlin.services.bedrock.model.CreateModelImportJobRequest
import aws.sdk.kotlin.services.bedrock.model.ModelDataSource
import aws.sdk.kotlin.services.bedrock.model.Tag
import aws.sdk.kotlin.services.bedrock.model.VpcConfig
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateModelImportJobOperationSerializer: HttpSerializer.NonStreaming<CreateModelImportJobRequest> {
    override fun serialize(context: ExecutionContext, input: CreateModelImportJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/model-import-jobs"
        }

        val payload = serializeCreateModelImportJobOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateModelImportJobOperationBody(context: ExecutionContext, input: CreateModelImportJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val IMPORTEDMODELKMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("importedModelKmsKeyId"))
    val IMPORTEDMODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("importedModelName"))
    val IMPORTEDMODELTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("importedModelTags"))
    val JOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobName"))
    val JOBTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("jobTags"))
    val MODELDATASOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("modelDataSource"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(IMPORTEDMODELKMSKEYID_DESCRIPTOR)
        field(IMPORTEDMODELNAME_DESCRIPTOR)
        field(IMPORTEDMODELTAGS_DESCRIPTOR)
        field(JOBNAME_DESCRIPTOR)
        field(JOBTAGS_DESCRIPTOR)
        field(MODELDATASOURCE_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) }
        input.importedModelKmsKeyId?.let { field(IMPORTEDMODELKMSKEYID_DESCRIPTOR, it) }
        input.importedModelName?.let { field(IMPORTEDMODELNAME_DESCRIPTOR, it) }
        if (input.importedModelTags != null) {
            listField(IMPORTEDMODELTAGS_DESCRIPTOR) {
                for (el0 in input.importedModelTags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.jobName?.let { field(JOBNAME_DESCRIPTOR, it) }
        if (input.jobTags != null) {
            listField(JOBTAGS_DESCRIPTOR) {
                for (el0 in input.jobTags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.modelDataSource?.let { field(MODELDATASOURCE_DESCRIPTOR, it, ::serializeModelDataSourceDocument) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        input.vpcConfig?.let { field(VPCCONFIG_DESCRIPTOR, it, ::serializeVpcConfigDocument) }
    }
    return serializer.toByteArray()
}
