// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.serde

import aws.sdk.kotlin.services.bedrock.model.CreateEvaluationJobRequest
import aws.sdk.kotlin.services.bedrock.model.EvaluationConfig
import aws.sdk.kotlin.services.bedrock.model.EvaluationInferenceConfig
import aws.sdk.kotlin.services.bedrock.model.EvaluationOutputDataConfig
import aws.sdk.kotlin.services.bedrock.model.Tag
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateEvaluationJobOperationSerializer: HttpSerializer.NonStreaming<CreateEvaluationJobRequest> {
    override fun serialize(context: ExecutionContext, input: CreateEvaluationJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/evaluation-jobs"
        }

        val payload = serializeCreateEvaluationJobOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateEvaluationJobOperationBody(context: ExecutionContext, input: CreateEvaluationJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val CUSTOMERENCRYPTIONKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customerEncryptionKeyId"))
    val EVALUATIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("evaluationConfig"))
    val INFERENCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("inferenceConfig"))
    val JOBDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobDescription"))
    val JOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobName"))
    val JOBTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("jobTags"))
    val OUTPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("outputDataConfig"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(CUSTOMERENCRYPTIONKEYID_DESCRIPTOR)
        field(EVALUATIONCONFIG_DESCRIPTOR)
        field(INFERENCECONFIG_DESCRIPTOR)
        field(JOBDESCRIPTION_DESCRIPTOR)
        field(JOBNAME_DESCRIPTOR)
        field(JOBTAGS_DESCRIPTOR)
        field(OUTPUTDATACONFIG_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.customerEncryptionKeyId?.let { field(CUSTOMERENCRYPTIONKEYID_DESCRIPTOR, it) }
        input.evaluationConfig?.let { field(EVALUATIONCONFIG_DESCRIPTOR, it, ::serializeEvaluationConfigDocument) }
        input.inferenceConfig?.let { field(INFERENCECONFIG_DESCRIPTOR, it, ::serializeEvaluationInferenceConfigDocument) }
        input.jobDescription?.let { field(JOBDESCRIPTION_DESCRIPTOR, it) }
        input.jobName?.let { field(JOBNAME_DESCRIPTOR, it) }
        if (input.jobTags != null) {
            listField(JOBTAGS_DESCRIPTOR) {
                for (el0 in input.jobTags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.outputDataConfig?.let { field(OUTPUTDATACONFIG_DESCRIPTOR, it, ::serializeEvaluationOutputDataConfigDocument) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
