// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.paginators

import aws.sdk.kotlin.services.bedrock.BedrockClient
import aws.sdk.kotlin.services.bedrock.model.CustomModelSummary
import aws.sdk.kotlin.services.bedrock.model.EvaluationSummary
import aws.sdk.kotlin.services.bedrock.model.GuardrailSummary
import aws.sdk.kotlin.services.bedrock.model.ImportedModelSummary
import aws.sdk.kotlin.services.bedrock.model.InferenceProfileSummary
import aws.sdk.kotlin.services.bedrock.model.ListCustomModelsRequest
import aws.sdk.kotlin.services.bedrock.model.ListCustomModelsResponse
import aws.sdk.kotlin.services.bedrock.model.ListEvaluationJobsRequest
import aws.sdk.kotlin.services.bedrock.model.ListEvaluationJobsResponse
import aws.sdk.kotlin.services.bedrock.model.ListGuardrailsRequest
import aws.sdk.kotlin.services.bedrock.model.ListGuardrailsResponse
import aws.sdk.kotlin.services.bedrock.model.ListImportedModelsRequest
import aws.sdk.kotlin.services.bedrock.model.ListImportedModelsResponse
import aws.sdk.kotlin.services.bedrock.model.ListInferenceProfilesRequest
import aws.sdk.kotlin.services.bedrock.model.ListInferenceProfilesResponse
import aws.sdk.kotlin.services.bedrock.model.ListModelCopyJobsRequest
import aws.sdk.kotlin.services.bedrock.model.ListModelCopyJobsResponse
import aws.sdk.kotlin.services.bedrock.model.ListModelCustomizationJobsRequest
import aws.sdk.kotlin.services.bedrock.model.ListModelCustomizationJobsResponse
import aws.sdk.kotlin.services.bedrock.model.ListModelImportJobsRequest
import aws.sdk.kotlin.services.bedrock.model.ListModelImportJobsResponse
import aws.sdk.kotlin.services.bedrock.model.ListModelInvocationJobsRequest
import aws.sdk.kotlin.services.bedrock.model.ListModelInvocationJobsResponse
import aws.sdk.kotlin.services.bedrock.model.ListProvisionedModelThroughputsRequest
import aws.sdk.kotlin.services.bedrock.model.ListProvisionedModelThroughputsResponse
import aws.sdk.kotlin.services.bedrock.model.ModelCopyJobSummary
import aws.sdk.kotlin.services.bedrock.model.ModelCustomizationJobSummary
import aws.sdk.kotlin.services.bedrock.model.ModelImportJobSummary
import aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobSummary
import aws.sdk.kotlin.services.bedrock.model.ProvisionedModelSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListCustomModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCustomModelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomModelsResponse]
 */
public fun BedrockClient.listCustomModelsPaginated(initialRequest: ListCustomModelsRequest = ListCustomModelsRequest { }): Flow<ListCustomModelsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomModelsPaginated.listCustomModels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomModelsResponse]
 */
public fun BedrockClient.listCustomModelsPaginated(block: ListCustomModelsRequest.Builder.() -> Unit): Flow<ListCustomModelsResponse> =
    listCustomModelsPaginated(ListCustomModelsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCustomModelsPaginated]
 * to access the nested member [CustomModelSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CustomModelSummary]
 */
@JvmName("listCustomModelsResponseCustomModelSummary")
public fun Flow<ListCustomModelsResponse>.modelSummaries(): Flow<CustomModelSummary> =
    transform() { response ->
        response.modelSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEvaluationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEvaluationJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEvaluationJobsResponse]
 */
public fun BedrockClient.listEvaluationJobsPaginated(initialRequest: ListEvaluationJobsRequest = ListEvaluationJobsRequest { }): Flow<ListEvaluationJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEvaluationJobsPaginated.listEvaluationJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEvaluationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEvaluationJobsResponse]
 */
public fun BedrockClient.listEvaluationJobsPaginated(block: ListEvaluationJobsRequest.Builder.() -> Unit): Flow<ListEvaluationJobsResponse> =
    listEvaluationJobsPaginated(ListEvaluationJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEvaluationJobsPaginated]
 * to access the nested member [EvaluationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EvaluationSummary]
 */
@JvmName("listEvaluationJobsResponseEvaluationSummary")
public fun Flow<ListEvaluationJobsResponse>.jobSummaries(): Flow<EvaluationSummary> =
    transform() { response ->
        response.jobSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGuardrailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGuardrailsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGuardrailsResponse]
 */
public fun BedrockClient.listGuardrailsPaginated(initialRequest: ListGuardrailsRequest = ListGuardrailsRequest { }): Flow<ListGuardrailsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGuardrailsPaginated.listGuardrails(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGuardrailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGuardrailsResponse]
 */
public fun BedrockClient.listGuardrailsPaginated(block: ListGuardrailsRequest.Builder.() -> Unit): Flow<ListGuardrailsResponse> =
    listGuardrailsPaginated(ListGuardrailsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGuardrailsPaginated]
 * to access the nested member [GuardrailSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GuardrailSummary]
 */
@JvmName("listGuardrailsResponseGuardrailSummary")
public fun Flow<ListGuardrailsResponse>.guardrails(): Flow<GuardrailSummary> =
    transform() { response ->
        response.guardrails?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListImportedModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImportedModelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportedModelsResponse]
 */
public fun BedrockClient.listImportedModelsPaginated(initialRequest: ListImportedModelsRequest = ListImportedModelsRequest { }): Flow<ListImportedModelsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImportedModelsPaginated.listImportedModels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImportedModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportedModelsResponse]
 */
public fun BedrockClient.listImportedModelsPaginated(block: ListImportedModelsRequest.Builder.() -> Unit): Flow<ListImportedModelsResponse> =
    listImportedModelsPaginated(ListImportedModelsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listImportedModelsPaginated]
 * to access the nested member [ImportedModelSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ImportedModelSummary]
 */
@JvmName("listImportedModelsResponseImportedModelSummary")
public fun Flow<ListImportedModelsResponse>.modelSummaries(): Flow<ImportedModelSummary> =
    transform() { response ->
        response.modelSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInferenceProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInferenceProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInferenceProfilesResponse]
 */
public fun BedrockClient.listInferenceProfilesPaginated(initialRequest: ListInferenceProfilesRequest = ListInferenceProfilesRequest { }): Flow<ListInferenceProfilesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInferenceProfilesPaginated.listInferenceProfiles(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListInferenceProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInferenceProfilesResponse]
 */
public fun BedrockClient.listInferenceProfilesPaginated(block: ListInferenceProfilesRequest.Builder.() -> Unit): Flow<ListInferenceProfilesResponse> =
    listInferenceProfilesPaginated(ListInferenceProfilesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInferenceProfilesPaginated]
 * to access the nested member [InferenceProfileSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InferenceProfileSummary]
 */
@JvmName("listInferenceProfilesResponseInferenceProfileSummary")
public fun Flow<ListInferenceProfilesResponse>.inferenceProfileSummaries(): Flow<InferenceProfileSummary> =
    transform() { response ->
        response.inferenceProfileSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListModelCopyJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListModelCopyJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListModelCopyJobsResponse]
 */
public fun BedrockClient.listModelCopyJobsPaginated(initialRequest: ListModelCopyJobsRequest = ListModelCopyJobsRequest { }): Flow<ListModelCopyJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listModelCopyJobsPaginated.listModelCopyJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListModelCopyJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListModelCopyJobsResponse]
 */
public fun BedrockClient.listModelCopyJobsPaginated(block: ListModelCopyJobsRequest.Builder.() -> Unit): Flow<ListModelCopyJobsResponse> =
    listModelCopyJobsPaginated(ListModelCopyJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listModelCopyJobsPaginated]
 * to access the nested member [ModelCopyJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ModelCopyJobSummary]
 */
@JvmName("listModelCopyJobsResponseModelCopyJobSummary")
public fun Flow<ListModelCopyJobsResponse>.modelCopyJobSummaries(): Flow<ModelCopyJobSummary> =
    transform() { response ->
        response.modelCopyJobSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListModelCustomizationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListModelCustomizationJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListModelCustomizationJobsResponse]
 */
public fun BedrockClient.listModelCustomizationJobsPaginated(initialRequest: ListModelCustomizationJobsRequest = ListModelCustomizationJobsRequest { }): Flow<ListModelCustomizationJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listModelCustomizationJobsPaginated.listModelCustomizationJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListModelCustomizationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListModelCustomizationJobsResponse]
 */
public fun BedrockClient.listModelCustomizationJobsPaginated(block: ListModelCustomizationJobsRequest.Builder.() -> Unit): Flow<ListModelCustomizationJobsResponse> =
    listModelCustomizationJobsPaginated(ListModelCustomizationJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listModelCustomizationJobsPaginated]
 * to access the nested member [ModelCustomizationJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ModelCustomizationJobSummary]
 */
@JvmName("listModelCustomizationJobsResponseModelCustomizationJobSummary")
public fun Flow<ListModelCustomizationJobsResponse>.modelCustomizationJobSummaries(): Flow<ModelCustomizationJobSummary> =
    transform() { response ->
        response.modelCustomizationJobSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListModelImportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListModelImportJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListModelImportJobsResponse]
 */
public fun BedrockClient.listModelImportJobsPaginated(initialRequest: ListModelImportJobsRequest = ListModelImportJobsRequest { }): Flow<ListModelImportJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listModelImportJobsPaginated.listModelImportJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListModelImportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListModelImportJobsResponse]
 */
public fun BedrockClient.listModelImportJobsPaginated(block: ListModelImportJobsRequest.Builder.() -> Unit): Flow<ListModelImportJobsResponse> =
    listModelImportJobsPaginated(ListModelImportJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listModelImportJobsPaginated]
 * to access the nested member [ModelImportJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ModelImportJobSummary]
 */
@JvmName("listModelImportJobsResponseModelImportJobSummary")
public fun Flow<ListModelImportJobsResponse>.modelImportJobSummaries(): Flow<ModelImportJobSummary> =
    transform() { response ->
        response.modelImportJobSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListModelInvocationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListModelInvocationJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListModelInvocationJobsResponse]
 */
public fun BedrockClient.listModelInvocationJobsPaginated(initialRequest: ListModelInvocationJobsRequest = ListModelInvocationJobsRequest { }): Flow<ListModelInvocationJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listModelInvocationJobsPaginated.listModelInvocationJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListModelInvocationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListModelInvocationJobsResponse]
 */
public fun BedrockClient.listModelInvocationJobsPaginated(block: ListModelInvocationJobsRequest.Builder.() -> Unit): Flow<ListModelInvocationJobsResponse> =
    listModelInvocationJobsPaginated(ListModelInvocationJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listModelInvocationJobsPaginated]
 * to access the nested member [ModelInvocationJobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ModelInvocationJobSummary]
 */
@JvmName("listModelInvocationJobsResponseModelInvocationJobSummary")
public fun Flow<ListModelInvocationJobsResponse>.invocationJobSummaries(): Flow<ModelInvocationJobSummary> =
    transform() { response ->
        response.invocationJobSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProvisionedModelThroughputsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProvisionedModelThroughputsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProvisionedModelThroughputsResponse]
 */
public fun BedrockClient.listProvisionedModelThroughputsPaginated(initialRequest: ListProvisionedModelThroughputsRequest = ListProvisionedModelThroughputsRequest { }): Flow<ListProvisionedModelThroughputsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProvisionedModelThroughputsPaginated.listProvisionedModelThroughputs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProvisionedModelThroughputsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProvisionedModelThroughputsResponse]
 */
public fun BedrockClient.listProvisionedModelThroughputsPaginated(block: ListProvisionedModelThroughputsRequest.Builder.() -> Unit): Flow<ListProvisionedModelThroughputsResponse> =
    listProvisionedModelThroughputsPaginated(ListProvisionedModelThroughputsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProvisionedModelThroughputsPaginated]
 * to access the nested member [ProvisionedModelSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProvisionedModelSummary]
 */
@JvmName("listProvisionedModelThroughputsResponseProvisionedModelSummary")
public fun Flow<ListProvisionedModelThroughputsResponse>.provisionedModelSummaries(): Flow<ProvisionedModelSummary> =
    transform() { response ->
        response.provisionedModelSummaries?.forEach {
            emit(it)
        }
    }
