// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration of a virtual private cloud (VPC). For more information, see [Protect your data using Amazon Virtual Private Cloud and Amazon Web Services PrivateLink](https://docs.aws.amazon.com/bedrock/latest/userguide/usingVPC.html).
 */
public class VpcConfig private constructor(builder: Builder) {
    /**
     * An array of IDs for each security group in the VPC to use.
     */
    public val securityGroupIds: List<String> = requireNotNull(builder.securityGroupIds) { "A non-null value must be provided for securityGroupIds" }
    /**
     * An array of IDs for each subnet in the VPC to use.
     */
    public val subnetIds: List<String> = requireNotNull(builder.subnetIds) { "A non-null value must be provided for subnetIds" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.VpcConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcConfig(")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = securityGroupIds.hashCode()
        result = 31 * result + (subnetIds.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcConfig

        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.VpcConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of IDs for each security group in the VPC to use.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * An array of IDs for each subnet in the VPC to use.
         */
        public var subnetIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.VpcConfig) : this() {
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.VpcConfig = VpcConfig(this)

        internal fun correctErrors(): Builder {
            if (securityGroupIds == null) securityGroupIds = emptyList()
            if (subnetIds == null) subnetIds = emptyList()
            return this
        }
    }
}
