// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of a batch inference job.
 */
public class ModelInvocationJobSummary private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The time at which the batch inference job ended.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Details about the location of the input to the batch inference job.
     */
    public val inputDataConfig: aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobInputDataConfig? = builder.inputDataConfig
    /**
     * The Amazon Resource Name (ARN) of the batch inference job.
     */
    public val jobArn: kotlin.String = requireNotNull(builder.jobArn) { "A non-null value must be provided for jobArn" }
    /**
     * The time at which the batch inference job times or timed out.
     */
    public val jobExpirationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.jobExpirationTime
    /**
     * The name of the batch inference job.
     */
    public val jobName: kotlin.String = requireNotNull(builder.jobName) { "A non-null value must be provided for jobName" }
    /**
     * The time at which the batch inference job was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * If the batch inference job failed, this field contains a message describing why the job failed.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The unique identifier of the foundation model used for model inference.
     */
    public val modelId: kotlin.String = requireNotNull(builder.modelId) { "A non-null value must be provided for modelId" }
    /**
     * Details about the location of the output of the batch inference job.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobOutputDataConfig? = builder.outputDataConfig
    /**
     * The Amazon Resource Name (ARN) of the service role with permissions to carry out and manage batch inference. You can use the console to create a default service role or follow the steps at [Create a service role for batch inference](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html).
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The status of the batch inference job.
     */
    public val status: aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobStatus? = builder.status
    /**
     * The time at which the batch inference job was submitted.
     */
    public val submitTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.submitTime) { "A non-null value must be provided for submitTime" }
    /**
     * The number of hours after which the batch inference job was set to time out.
     */
    public val timeoutDurationInHours: kotlin.Int? = builder.timeoutDurationInHours
    /**
     * The configuration of the Virtual Private Cloud (VPC) for the data in the batch inference job. For more information, see [Protect batch inference jobs using a VPC](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-vpc).
     */
    public val vpcConfig: aws.sdk.kotlin.services.bedrock.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelInvocationJobSummary(")
        append("clientRequestToken=$clientRequestToken,")
        append("endTime=$endTime,")
        append("inputDataConfig=$inputDataConfig,")
        append("jobArn=$jobArn,")
        append("jobExpirationTime=$jobExpirationTime,")
        append("jobName=$jobName,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("message=*** Sensitive Data Redacted ***,")
        append("modelId=$modelId,")
        append("outputDataConfig=$outputDataConfig,")
        append("roleArn=$roleArn,")
        append("status=$status,")
        append("submitTime=$submitTime,")
        append("timeoutDurationInHours=$timeoutDurationInHours,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (jobArn.hashCode())
        result = 31 * result + (jobExpirationTime?.hashCode() ?: 0)
        result = 31 * result + (jobName.hashCode())
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (modelId.hashCode())
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (submitTime.hashCode())
        result = 31 * result + (timeoutDurationInHours ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelInvocationJobSummary

        if (clientRequestToken != other.clientRequestToken) return false
        if (endTime != other.endTime) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (jobArn != other.jobArn) return false
        if (jobExpirationTime != other.jobExpirationTime) return false
        if (jobName != other.jobName) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (message != other.message) return false
        if (modelId != other.modelId) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false
        if (submitTime != other.submitTime) return false
        if (timeoutDurationInHours != other.timeoutDurationInHours) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see [Ensuring idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The time at which the batch inference job ended.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Details about the location of the input to the batch inference job.
         */
        public var inputDataConfig: aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobInputDataConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the batch inference job.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The time at which the batch inference job times or timed out.
         */
        public var jobExpirationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the batch inference job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The time at which the batch inference job was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the batch inference job failed, this field contains a message describing why the job failed.
         */
        public var message: kotlin.String? = null
        /**
         * The unique identifier of the foundation model used for model inference.
         */
        public var modelId: kotlin.String? = null
        /**
         * Details about the location of the output of the batch inference job.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobOutputDataConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the service role with permissions to carry out and manage batch inference. You can use the console to create a default service role or follow the steps at [Create a service role for batch inference](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html).
         */
        public var roleArn: kotlin.String? = null
        /**
         * The status of the batch inference job.
         */
        public var status: aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobStatus? = null
        /**
         * The time at which the batch inference job was submitted.
         */
        public var submitTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of hours after which the batch inference job was set to time out.
         */
        public var timeoutDurationInHours: kotlin.Int? = null
        /**
         * The configuration of the Virtual Private Cloud (VPC) for the data in the batch inference job. For more information, see [Protect batch inference jobs using a VPC](https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-vpc).
         */
        public var vpcConfig: aws.sdk.kotlin.services.bedrock.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobSummary) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.endTime = x.endTime
            this.inputDataConfig = x.inputDataConfig
            this.jobArn = x.jobArn
            this.jobExpirationTime = x.jobExpirationTime
            this.jobName = x.jobName
            this.lastModifiedTime = x.lastModifiedTime
            this.message = x.message
            this.modelId = x.modelId
            this.outputDataConfig = x.outputDataConfig
            this.roleArn = x.roleArn
            this.status = x.status
            this.submitTime = x.submitTime
            this.timeoutDurationInHours = x.timeoutDurationInHours
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobSummary = ModelInvocationJobSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.bedrock.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.bedrock.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (jobArn == null) jobArn = ""
            if (jobName == null) jobName = ""
            if (modelId == null) modelId = ""
            if (roleArn == null) roleArn = ""
            if (submitTime == null) submitTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
