// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the configuration of the S3 location of the output data.
 */
public class ModelInvocationJobS3OutputDataConfig private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account that owns the S3 bucket containing the output data.
     */
    public val s3BucketOwner: kotlin.String? = builder.s3BucketOwner
    /**
     * The unique identifier of the key that encrypts the S3 location of the output data.
     */
    public val s3EncryptionKeyId: kotlin.String? = builder.s3EncryptionKeyId
    /**
     * The S3 location of the output data.
     */
    public val s3Uri: kotlin.String = requireNotNull(builder.s3Uri) { "A non-null value must be provided for s3Uri" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobS3OutputDataConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelInvocationJobS3OutputDataConfig(")
        append("s3BucketOwner=$s3BucketOwner,")
        append("s3EncryptionKeyId=$s3EncryptionKeyId,")
        append("s3Uri=$s3Uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3BucketOwner?.hashCode() ?: 0
        result = 31 * result + (s3EncryptionKeyId?.hashCode() ?: 0)
        result = 31 * result + (s3Uri.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelInvocationJobS3OutputDataConfig

        if (s3BucketOwner != other.s3BucketOwner) return false
        if (s3EncryptionKeyId != other.s3EncryptionKeyId) return false
        if (s3Uri != other.s3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobS3OutputDataConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Amazon Web Services account that owns the S3 bucket containing the output data.
         */
        public var s3BucketOwner: kotlin.String? = null
        /**
         * The unique identifier of the key that encrypts the S3 location of the output data.
         */
        public var s3EncryptionKeyId: kotlin.String? = null
        /**
         * The S3 location of the output data.
         */
        public var s3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobS3OutputDataConfig) : this() {
            this.s3BucketOwner = x.s3BucketOwner
            this.s3EncryptionKeyId = x.s3EncryptionKeyId
            this.s3Uri = x.s3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.ModelInvocationJobS3OutputDataConfig = ModelInvocationJobS3OutputDataConfig(this)

        internal fun correctErrors(): Builder {
            if (s3Uri == null) s3Uri = ""
            return this
        }
    }
}
