// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the import job.
 */
public class ModelImportJobSummary private constructor(builder: Builder) {
    /**
     * The time import job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The time when import job ended.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The Amazon resource Name (ARN) of the imported model.
     */
    public val importedModelArn: kotlin.String? = builder.importedModelArn
    /**
     * The name of the imported model.
     */
    public val importedModelName: kotlin.String? = builder.importedModelName
    /**
     * The Amazon Resource Name (ARN) of the import job.
     */
    public val jobArn: kotlin.String = requireNotNull(builder.jobArn) { "A non-null value must be provided for jobArn" }
    /**
     * The name of the import job.
     */
    public val jobName: kotlin.String = requireNotNull(builder.jobName) { "A non-null value must be provided for jobName" }
    /**
     * The time when the import job was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The status of the imported job.
     */
    public val status: aws.sdk.kotlin.services.bedrock.model.ModelImportJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.ModelImportJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelImportJobSummary(")
        append("creationTime=$creationTime,")
        append("endTime=$endTime,")
        append("importedModelArn=$importedModelArn,")
        append("importedModelName=$importedModelName,")
        append("jobArn=$jobArn,")
        append("jobName=$jobName,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (importedModelArn?.hashCode() ?: 0)
        result = 31 * result + (importedModelName?.hashCode() ?: 0)
        result = 31 * result + (jobArn.hashCode())
        result = 31 * result + (jobName.hashCode())
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelImportJobSummary

        if (creationTime != other.creationTime) return false
        if (endTime != other.endTime) return false
        if (importedModelArn != other.importedModelArn) return false
        if (importedModelName != other.importedModelName) return false
        if (jobArn != other.jobArn) return false
        if (jobName != other.jobName) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.ModelImportJobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time import job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when import job ended.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon resource Name (ARN) of the imported model.
         */
        public var importedModelArn: kotlin.String? = null
        /**
         * The name of the imported model.
         */
        public var importedModelName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the import job.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The name of the import job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The time when the import job was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the imported job.
         */
        public var status: aws.sdk.kotlin.services.bedrock.model.ModelImportJobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.ModelImportJobSummary) : this() {
            this.creationTime = x.creationTime
            this.endTime = x.endTime
            this.importedModelArn = x.importedModelArn
            this.importedModelName = x.importedModelName
            this.jobArn = x.jobArn
            this.jobName = x.jobName
            this.lastModifiedTime = x.lastModifiedTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.ModelImportJobSummary = ModelImportJobSummary(this)

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (jobArn == null) jobArn = ""
            if (jobName == null) jobName = ""
            if (status == null) status = ModelImportJobStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
