// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about one customization job
 */
public class ModelCustomizationJobSummary private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the base model.
     */
    public val baseModelArn: kotlin.String = requireNotNull(builder.baseModelArn) { "A non-null value must be provided for baseModelArn" }
    /**
     * Creation time of the custom model.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * Amazon Resource Name (ARN) of the custom model.
     */
    public val customModelArn: kotlin.String? = builder.customModelArn
    /**
     * Name of the custom model.
     */
    public val customModelName: kotlin.String? = builder.customModelName
    /**
     * Specifies whether to carry out continued pre-training of a model or whether to fine-tune it. For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html).
     */
    public val customizationType: aws.sdk.kotlin.services.bedrock.model.CustomizationType? = builder.customizationType
    /**
     * Time that the customization job ended.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Amazon Resource Name (ARN) of the customization job.
     */
    public val jobArn: kotlin.String = requireNotNull(builder.jobArn) { "A non-null value must be provided for jobArn" }
    /**
     * Name of the customization job.
     */
    public val jobName: kotlin.String = requireNotNull(builder.jobName) { "A non-null value must be provided for jobName" }
    /**
     * Time that the customization job was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Status of the customization job.
     */
    public val status: aws.sdk.kotlin.services.bedrock.model.ModelCustomizationJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.ModelCustomizationJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelCustomizationJobSummary(")
        append("baseModelArn=$baseModelArn,")
        append("creationTime=$creationTime,")
        append("customModelArn=$customModelArn,")
        append("customModelName=$customModelName,")
        append("customizationType=$customizationType,")
        append("endTime=$endTime,")
        append("jobArn=$jobArn,")
        append("jobName=$jobName,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseModelArn.hashCode()
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (customModelArn?.hashCode() ?: 0)
        result = 31 * result + (customModelName?.hashCode() ?: 0)
        result = 31 * result + (customizationType?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (jobArn.hashCode())
        result = 31 * result + (jobName.hashCode())
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelCustomizationJobSummary

        if (baseModelArn != other.baseModelArn) return false
        if (creationTime != other.creationTime) return false
        if (customModelArn != other.customModelArn) return false
        if (customModelName != other.customModelName) return false
        if (customizationType != other.customizationType) return false
        if (endTime != other.endTime) return false
        if (jobArn != other.jobArn) return false
        if (jobName != other.jobName) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.ModelCustomizationJobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the base model.
         */
        public var baseModelArn: kotlin.String? = null
        /**
         * Creation time of the custom model.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Amazon Resource Name (ARN) of the custom model.
         */
        public var customModelArn: kotlin.String? = null
        /**
         * Name of the custom model.
         */
        public var customModelName: kotlin.String? = null
        /**
         * Specifies whether to carry out continued pre-training of a model or whether to fine-tune it. For more information, see [Custom models](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html).
         */
        public var customizationType: aws.sdk.kotlin.services.bedrock.model.CustomizationType? = null
        /**
         * Time that the customization job ended.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Amazon Resource Name (ARN) of the customization job.
         */
        public var jobArn: kotlin.String? = null
        /**
         * Name of the customization job.
         */
        public var jobName: kotlin.String? = null
        /**
         * Time that the customization job was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Status of the customization job.
         */
        public var status: aws.sdk.kotlin.services.bedrock.model.ModelCustomizationJobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.ModelCustomizationJobSummary) : this() {
            this.baseModelArn = x.baseModelArn
            this.creationTime = x.creationTime
            this.customModelArn = x.customModelArn
            this.customModelName = x.customModelName
            this.customizationType = x.customizationType
            this.endTime = x.endTime
            this.jobArn = x.jobArn
            this.jobName = x.jobName
            this.lastModifiedTime = x.lastModifiedTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.ModelCustomizationJobSummary = ModelCustomizationJobSummary(this)

        internal fun correctErrors(): Builder {
            if (baseModelArn == null) baseModelArn = ""
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (jobArn == null) jobArn = ""
            if (jobName == null) jobName = ""
            if (status == null) status = ModelCustomizationJobStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
