// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the imported model.
 */
public class ImportedModelSummary private constructor(builder: Builder) {
    /**
     * Creation time of the imported model.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * Specifies if the imported model supports converse.
     */
    public val instructSupported: kotlin.Boolean? = builder.instructSupported
    /**
     * The architecture of the imported model.
     */
    public val modelArchitecture: kotlin.String? = builder.modelArchitecture
    /**
     * The Amazon Resource Name (ARN) of the imported model.
     */
    public val modelArn: kotlin.String = requireNotNull(builder.modelArn) { "A non-null value must be provided for modelArn" }
    /**
     * Name of the imported model.
     */
    public val modelName: kotlin.String = requireNotNull(builder.modelName) { "A non-null value must be provided for modelName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.ImportedModelSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportedModelSummary(")
        append("creationTime=$creationTime,")
        append("instructSupported=$instructSupported,")
        append("modelArchitecture=$modelArchitecture,")
        append("modelArn=$modelArn,")
        append("modelName=$modelName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (instructSupported?.hashCode() ?: 0)
        result = 31 * result + (modelArchitecture?.hashCode() ?: 0)
        result = 31 * result + (modelArn.hashCode())
        result = 31 * result + (modelName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportedModelSummary

        if (creationTime != other.creationTime) return false
        if (instructSupported != other.instructSupported) return false
        if (modelArchitecture != other.modelArchitecture) return false
        if (modelArn != other.modelArn) return false
        if (modelName != other.modelName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.ImportedModelSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Creation time of the imported model.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies if the imported model supports converse.
         */
        public var instructSupported: kotlin.Boolean? = null
        /**
         * The architecture of the imported model.
         */
        public var modelArchitecture: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the imported model.
         */
        public var modelArn: kotlin.String? = null
        /**
         * Name of the imported model.
         */
        public var modelName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.ImportedModelSummary) : this() {
            this.creationTime = x.creationTime
            this.instructSupported = x.instructSupported
            this.modelArchitecture = x.modelArchitecture
            this.modelArn = x.modelArn
            this.modelName = x.modelName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.ImportedModelSummary = ImportedModelSummary(this)

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (modelArn == null) modelArn = ""
            if (modelName == null) modelName = ""
            return this
        }
    }
}
