// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the custom metrics, how tasks will be rated, the flow definition ARN, and your custom prompt datasets. Model evaluation jobs use human workers *only* support the use of custom prompt datasets. To learn more about custom prompt datasets and the required format, see [Custom prompt datasets](https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-prompt-datasets-custom.html).
 *
 * When you create custom metrics in `HumanEvaluationCustomMetric` you must specify the metric's `name`. The list of `names` specified in the `HumanEvaluationCustomMetric` array, must match the `metricNames` array of strings specified in `EvaluationDatasetMetricConfig`. For example, if in the `HumanEvaluationCustomMetric` array your specified the names `"accuracy", "toxicity", "readability"` as custom metrics *then* the `metricNames` array would need to look like the following `["accuracy", "toxicity", "readability"]` in `EvaluationDatasetMetricConfig`.
 */
public class HumanEvaluationConfig private constructor(builder: Builder) {
    /**
     * A `HumanEvaluationCustomMetric` object. It contains the names the metrics, how the metrics are to be evaluated, an optional description.
     */
    public val customMetrics: List<HumanEvaluationCustomMetric>? = builder.customMetrics
    /**
     * Use to specify the metrics, task, and prompt dataset to be used in your model evaluation job.
     */
    public val datasetMetricConfigs: List<EvaluationDatasetMetricConfig> = requireNotNull(builder.datasetMetricConfigs) { "A non-null value must be provided for datasetMetricConfigs" }
    /**
     * The parameters of the human workflow.
     */
    public val humanWorkflowConfig: aws.sdk.kotlin.services.bedrock.model.HumanWorkflowConfig? = builder.humanWorkflowConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.HumanEvaluationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HumanEvaluationConfig(")
        append("customMetrics=$customMetrics,")
        append("datasetMetricConfigs=$datasetMetricConfigs,")
        append("humanWorkflowConfig=$humanWorkflowConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customMetrics?.hashCode() ?: 0
        result = 31 * result + (datasetMetricConfigs.hashCode())
        result = 31 * result + (humanWorkflowConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HumanEvaluationConfig

        if (customMetrics != other.customMetrics) return false
        if (datasetMetricConfigs != other.datasetMetricConfigs) return false
        if (humanWorkflowConfig != other.humanWorkflowConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.HumanEvaluationConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A `HumanEvaluationCustomMetric` object. It contains the names the metrics, how the metrics are to be evaluated, an optional description.
         */
        public var customMetrics: List<HumanEvaluationCustomMetric>? = null
        /**
         * Use to specify the metrics, task, and prompt dataset to be used in your model evaluation job.
         */
        public var datasetMetricConfigs: List<EvaluationDatasetMetricConfig>? = null
        /**
         * The parameters of the human workflow.
         */
        public var humanWorkflowConfig: aws.sdk.kotlin.services.bedrock.model.HumanWorkflowConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.HumanEvaluationConfig) : this() {
            this.customMetrics = x.customMetrics
            this.datasetMetricConfigs = x.datasetMetricConfigs
            this.humanWorkflowConfig = x.humanWorkflowConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.HumanEvaluationConfig = HumanEvaluationConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.HumanWorkflowConfig] inside the given [block]
         */
        public fun humanWorkflowConfig(block: aws.sdk.kotlin.services.bedrock.model.HumanWorkflowConfig.Builder.() -> kotlin.Unit) {
            this.humanWorkflowConfig = aws.sdk.kotlin.services.bedrock.model.HumanWorkflowConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (datasetMetricConfigs == null) datasetMetricConfigs = emptyList()
            return this
        }
    }
}
