// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about topics for the guardrail to identify and deny.
 */
public class GuardrailTopicConfig private constructor(builder: Builder) {
    /**
     * A definition of the topic to deny.
     */
    public val definition: kotlin.String = requireNotNull(builder.definition) { "A non-null value must be provided for definition" }
    /**
     * A list of prompts, each of which is an example of a prompt that can be categorized as belonging to the topic.
     */
    public val examples: List<String>? = builder.examples
    /**
     * The name of the topic to deny.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Specifies to deny the topic.
     */
    public val type: aws.sdk.kotlin.services.bedrock.model.GuardrailTopicType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.GuardrailTopicConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GuardrailTopicConfig(")
        append("definition=*** Sensitive Data Redacted ***,")
        append("examples=*** Sensitive Data Redacted ***,")
        append("name=*** Sensitive Data Redacted ***,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = definition.hashCode()
        result = 31 * result + (examples?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GuardrailTopicConfig

        if (definition != other.definition) return false
        if (examples != other.examples) return false
        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.GuardrailTopicConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A definition of the topic to deny.
         */
        public var definition: kotlin.String? = null
        /**
         * A list of prompts, each of which is an example of a prompt that can be categorized as belonging to the topic.
         */
        public var examples: List<String>? = null
        /**
         * The name of the topic to deny.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies to deny the topic.
         */
        public var type: aws.sdk.kotlin.services.bedrock.model.GuardrailTopicType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.GuardrailTopicConfig) : this() {
            this.definition = x.definition
            this.examples = x.examples
            this.name = x.name
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.GuardrailTopicConfig = GuardrailTopicConfig(this)

        internal fun correctErrors(): Builder {
            if (definition == null) definition = ""
            if (name == null) name = ""
            if (type == null) type = GuardrailTopicType.SdkUnknown("no value provided")
            return this
        }
    }
}
