// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about a guardrail.
 *
 * This data type is used in the following API operations:
 * + [ListGuardrails response body](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListGuardrails.html#API_ListGuardrails_ResponseSyntax)
 */
public class GuardrailSummary private constructor(builder: Builder) {
    /**
     * The ARN of the guardrail.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The date and time at which the guardrail was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * A description of the guardrail.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The unique identifier of the guardrail.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The name of the guardrail.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the guardrail.
     */
    public val status: aws.sdk.kotlin.services.bedrock.model.GuardrailStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The date and time at which the guardrail was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }
    /**
     * The version of the guardrail.
     */
    public val version: kotlin.String = requireNotNull(builder.version) { "A non-null value must be provided for version" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.GuardrailSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GuardrailSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("description=*** Sensitive Data Redacted ***,")
        append("id=$id,")
        append("name=*** Sensitive Data Redacted ***,")
        append("status=$status,")
        append("updatedAt=$updatedAt,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        result = 31 * result + (version.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GuardrailSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.GuardrailSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the guardrail.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time at which the guardrail was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of the guardrail.
         */
        public var description: kotlin.String? = null
        /**
         * The unique identifier of the guardrail.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the guardrail.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the guardrail.
         */
        public var status: aws.sdk.kotlin.services.bedrock.model.GuardrailStatus? = null
        /**
         * The date and time at which the guardrail was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The version of the guardrail.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.GuardrailSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.status = x.status
            this.updatedAt = x.updatedAt
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.GuardrailSummary = GuardrailSummary(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (id == null) id = ""
            if (name == null) name = ""
            if (status == null) status = GuardrailStatus.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            if (version == null) version = ""
            return this
        }
    }
}
