// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetModelCustomizationJobResponse private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the base model.
     */
    public val baseModelArn: kotlin.String = requireNotNull(builder.baseModelArn) { "A non-null value must be provided for baseModelArn" }
    /**
     * The token that you specified in the `CreateCustomizationJob` request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Time that the resource was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The type of model customization.
     */
    public val customizationType: aws.sdk.kotlin.services.bedrock.model.CustomizationType? = builder.customizationType
    /**
     * Time that the resource transitioned to terminal state.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Information about why the job failed.
     */
    public val failureMessage: kotlin.String? = builder.failureMessage
    /**
     * The hyperparameter values for the job. For details on the format for different models, see [Custom model hyperparameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html).
     */
    public val hyperParameters: Map<String, String> = requireNotNull(builder.hyperParameters) { "A non-null value must be provided for hyperParameters" }
    /**
     * The Amazon Resource Name (ARN) of the customization job.
     */
    public val jobArn: kotlin.String = requireNotNull(builder.jobArn) { "A non-null value must be provided for jobArn" }
    /**
     * The name of the customization job.
     */
    public val jobName: kotlin.String = requireNotNull(builder.jobName) { "A non-null value must be provided for jobName" }
    /**
     * Time that the resource was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Output data configuration
     */
    public val outputDataConfig: aws.sdk.kotlin.services.bedrock.model.OutputDataConfig? = builder.outputDataConfig
    /**
     * The Amazon Resource Name (ARN) of the output model.
     */
    public val outputModelArn: kotlin.String? = builder.outputModelArn
    /**
     * The custom model is encrypted at rest using this key.
     */
    public val outputModelKmsKeyArn: kotlin.String? = builder.outputModelKmsKeyArn
    /**
     * The name of the output model.
     */
    public val outputModelName: kotlin.String = requireNotNull(builder.outputModelName) { "A non-null value must be provided for outputModelName" }
    /**
     * The Amazon Resource Name (ARN) of the IAM role.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The status of the job. A successful job transitions from in-progress to completed when the output model is ready to use. If the job failed, the failure message contains information about why the job failed.
     */
    public val status: aws.sdk.kotlin.services.bedrock.model.ModelCustomizationJobStatus? = builder.status
    /**
     * Contains information about the training dataset.
     */
    public val trainingDataConfig: aws.sdk.kotlin.services.bedrock.model.TrainingDataConfig? = builder.trainingDataConfig
    /**
     * Contains training metrics from the job creation.
     */
    public val trainingMetrics: aws.sdk.kotlin.services.bedrock.model.TrainingMetrics? = builder.trainingMetrics
    /**
     * Contains information about the validation dataset.
     */
    public val validationDataConfig: aws.sdk.kotlin.services.bedrock.model.ValidationDataConfig? = builder.validationDataConfig
    /**
     * The loss metric for each validator that you provided in the createjob request.
     */
    public val validationMetrics: List<ValidatorMetric>? = builder.validationMetrics
    /**
     * VPC configuration for the custom model job.
     */
    public val vpcConfig: aws.sdk.kotlin.services.bedrock.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.GetModelCustomizationJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetModelCustomizationJobResponse(")
        append("baseModelArn=$baseModelArn,")
        append("clientRequestToken=$clientRequestToken,")
        append("creationTime=$creationTime,")
        append("customizationType=$customizationType,")
        append("endTime=$endTime,")
        append("failureMessage=$failureMessage,")
        append("hyperParameters=$hyperParameters,")
        append("jobArn=$jobArn,")
        append("jobName=$jobName,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("outputDataConfig=$outputDataConfig,")
        append("outputModelArn=$outputModelArn,")
        append("outputModelKmsKeyArn=$outputModelKmsKeyArn,")
        append("outputModelName=$outputModelName,")
        append("roleArn=$roleArn,")
        append("status=$status,")
        append("trainingDataConfig=$trainingDataConfig,")
        append("trainingMetrics=$trainingMetrics,")
        append("validationDataConfig=$validationDataConfig,")
        append("validationMetrics=$validationMetrics,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseModelArn.hashCode()
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (customizationType?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (failureMessage?.hashCode() ?: 0)
        result = 31 * result + (hyperParameters.hashCode())
        result = 31 * result + (jobArn.hashCode())
        result = 31 * result + (jobName.hashCode())
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (outputModelArn?.hashCode() ?: 0)
        result = 31 * result + (outputModelKmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (outputModelName.hashCode())
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (trainingDataConfig?.hashCode() ?: 0)
        result = 31 * result + (trainingMetrics?.hashCode() ?: 0)
        result = 31 * result + (validationDataConfig?.hashCode() ?: 0)
        result = 31 * result + (validationMetrics?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetModelCustomizationJobResponse

        if (baseModelArn != other.baseModelArn) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (creationTime != other.creationTime) return false
        if (customizationType != other.customizationType) return false
        if (endTime != other.endTime) return false
        if (failureMessage != other.failureMessage) return false
        if (hyperParameters != other.hyperParameters) return false
        if (jobArn != other.jobArn) return false
        if (jobName != other.jobName) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (outputModelArn != other.outputModelArn) return false
        if (outputModelKmsKeyArn != other.outputModelKmsKeyArn) return false
        if (outputModelName != other.outputModelName) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false
        if (trainingDataConfig != other.trainingDataConfig) return false
        if (trainingMetrics != other.trainingMetrics) return false
        if (validationDataConfig != other.validationDataConfig) return false
        if (validationMetrics != other.validationMetrics) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.GetModelCustomizationJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the base model.
         */
        public var baseModelArn: kotlin.String? = null
        /**
         * The token that you specified in the `CreateCustomizationJob` request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Time that the resource was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of model customization.
         */
        public var customizationType: aws.sdk.kotlin.services.bedrock.model.CustomizationType? = null
        /**
         * Time that the resource transitioned to terminal state.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about why the job failed.
         */
        public var failureMessage: kotlin.String? = null
        /**
         * The hyperparameter values for the job. For details on the format for different models, see [Custom model hyperparameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html).
         */
        public var hyperParameters: Map<String, String>? = null
        /**
         * The Amazon Resource Name (ARN) of the customization job.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The name of the customization job.
         */
        public var jobName: kotlin.String? = null
        /**
         * Time that the resource was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Output data configuration
         */
        public var outputDataConfig: aws.sdk.kotlin.services.bedrock.model.OutputDataConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the output model.
         */
        public var outputModelArn: kotlin.String? = null
        /**
         * The custom model is encrypted at rest using this key.
         */
        public var outputModelKmsKeyArn: kotlin.String? = null
        /**
         * The name of the output model.
         */
        public var outputModelName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The status of the job. A successful job transitions from in-progress to completed when the output model is ready to use. If the job failed, the failure message contains information about why the job failed.
         */
        public var status: aws.sdk.kotlin.services.bedrock.model.ModelCustomizationJobStatus? = null
        /**
         * Contains information about the training dataset.
         */
        public var trainingDataConfig: aws.sdk.kotlin.services.bedrock.model.TrainingDataConfig? = null
        /**
         * Contains training metrics from the job creation.
         */
        public var trainingMetrics: aws.sdk.kotlin.services.bedrock.model.TrainingMetrics? = null
        /**
         * Contains information about the validation dataset.
         */
        public var validationDataConfig: aws.sdk.kotlin.services.bedrock.model.ValidationDataConfig? = null
        /**
         * The loss metric for each validator that you provided in the createjob request.
         */
        public var validationMetrics: List<ValidatorMetric>? = null
        /**
         * VPC configuration for the custom model job.
         */
        public var vpcConfig: aws.sdk.kotlin.services.bedrock.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.GetModelCustomizationJobResponse) : this() {
            this.baseModelArn = x.baseModelArn
            this.clientRequestToken = x.clientRequestToken
            this.creationTime = x.creationTime
            this.customizationType = x.customizationType
            this.endTime = x.endTime
            this.failureMessage = x.failureMessage
            this.hyperParameters = x.hyperParameters
            this.jobArn = x.jobArn
            this.jobName = x.jobName
            this.lastModifiedTime = x.lastModifiedTime
            this.outputDataConfig = x.outputDataConfig
            this.outputModelArn = x.outputModelArn
            this.outputModelKmsKeyArn = x.outputModelKmsKeyArn
            this.outputModelName = x.outputModelName
            this.roleArn = x.roleArn
            this.status = x.status
            this.trainingDataConfig = x.trainingDataConfig
            this.trainingMetrics = x.trainingMetrics
            this.validationDataConfig = x.validationDataConfig
            this.validationMetrics = x.validationMetrics
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.GetModelCustomizationJobResponse = GetModelCustomizationJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.OutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.bedrock.model.OutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.bedrock.model.OutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.TrainingDataConfig] inside the given [block]
         */
        public fun trainingDataConfig(block: aws.sdk.kotlin.services.bedrock.model.TrainingDataConfig.Builder.() -> kotlin.Unit) {
            this.trainingDataConfig = aws.sdk.kotlin.services.bedrock.model.TrainingDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.TrainingMetrics] inside the given [block]
         */
        public fun trainingMetrics(block: aws.sdk.kotlin.services.bedrock.model.TrainingMetrics.Builder.() -> kotlin.Unit) {
            this.trainingMetrics = aws.sdk.kotlin.services.bedrock.model.TrainingMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.ValidationDataConfig] inside the given [block]
         */
        public fun validationDataConfig(block: aws.sdk.kotlin.services.bedrock.model.ValidationDataConfig.Builder.() -> kotlin.Unit) {
            this.validationDataConfig = aws.sdk.kotlin.services.bedrock.model.ValidationDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.bedrock.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.bedrock.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (baseModelArn == null) baseModelArn = ""
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (hyperParameters == null) hyperParameters = emptyMap()
            if (jobArn == null) jobArn = ""
            if (jobName == null) jobName = ""
            if (outputModelName == null) outputModelName = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
