// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetModelCopyJobResponse private constructor(builder: Builder) {
    /**
     * The time at which the model copy job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * An error message for why the model copy job failed.
     */
    public val failureMessage: kotlin.String? = builder.failureMessage
    /**
     * The Amazon Resource Name (ARN) of the model copy job.
     */
    public val jobArn: kotlin.String = requireNotNull(builder.jobArn) { "A non-null value must be provided for jobArn" }
    /**
     * The unique identifier of the account that the model being copied originated from.
     */
    public val sourceAccountId: kotlin.String = requireNotNull(builder.sourceAccountId) { "A non-null value must be provided for sourceAccountId" }
    /**
     * The Amazon Resource Name (ARN) of the original model being copied.
     */
    public val sourceModelArn: kotlin.String = requireNotNull(builder.sourceModelArn) { "A non-null value must be provided for sourceModelArn" }
    /**
     * The name of the original model being copied.
     */
    public val sourceModelName: kotlin.String? = builder.sourceModelName
    /**
     * The status of the model copy job.
     */
    public val status: aws.sdk.kotlin.services.bedrock.model.ModelCopyJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The Amazon Resource Name (ARN) of the copied model.
     */
    public val targetModelArn: kotlin.String = requireNotNull(builder.targetModelArn) { "A non-null value must be provided for targetModelArn" }
    /**
     * The Amazon Resource Name (ARN) of the KMS key encrypting the copied model.
     */
    public val targetModelKmsKeyArn: kotlin.String? = builder.targetModelKmsKeyArn
    /**
     * The name of the copied model.
     */
    public val targetModelName: kotlin.String? = builder.targetModelName
    /**
     * The tags associated with the copied model.
     */
    public val targetModelTags: List<Tag>? = builder.targetModelTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.GetModelCopyJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetModelCopyJobResponse(")
        append("creationTime=$creationTime,")
        append("failureMessage=$failureMessage,")
        append("jobArn=$jobArn,")
        append("sourceAccountId=$sourceAccountId,")
        append("sourceModelArn=$sourceModelArn,")
        append("sourceModelName=$sourceModelName,")
        append("status=$status,")
        append("targetModelArn=$targetModelArn,")
        append("targetModelKmsKeyArn=$targetModelKmsKeyArn,")
        append("targetModelName=$targetModelName,")
        append("targetModelTags=$targetModelTags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (failureMessage?.hashCode() ?: 0)
        result = 31 * result + (jobArn.hashCode())
        result = 31 * result + (sourceAccountId.hashCode())
        result = 31 * result + (sourceModelArn.hashCode())
        result = 31 * result + (sourceModelName?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (targetModelArn.hashCode())
        result = 31 * result + (targetModelKmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (targetModelName?.hashCode() ?: 0)
        result = 31 * result + (targetModelTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetModelCopyJobResponse

        if (creationTime != other.creationTime) return false
        if (failureMessage != other.failureMessage) return false
        if (jobArn != other.jobArn) return false
        if (sourceAccountId != other.sourceAccountId) return false
        if (sourceModelArn != other.sourceModelArn) return false
        if (sourceModelName != other.sourceModelName) return false
        if (status != other.status) return false
        if (targetModelArn != other.targetModelArn) return false
        if (targetModelKmsKeyArn != other.targetModelKmsKeyArn) return false
        if (targetModelName != other.targetModelName) return false
        if (targetModelTags != other.targetModelTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.GetModelCopyJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time at which the model copy job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An error message for why the model copy job failed.
         */
        public var failureMessage: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the model copy job.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The unique identifier of the account that the model being copied originated from.
         */
        public var sourceAccountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the original model being copied.
         */
        public var sourceModelArn: kotlin.String? = null
        /**
         * The name of the original model being copied.
         */
        public var sourceModelName: kotlin.String? = null
        /**
         * The status of the model copy job.
         */
        public var status: aws.sdk.kotlin.services.bedrock.model.ModelCopyJobStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the copied model.
         */
        public var targetModelArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the KMS key encrypting the copied model.
         */
        public var targetModelKmsKeyArn: kotlin.String? = null
        /**
         * The name of the copied model.
         */
        public var targetModelName: kotlin.String? = null
        /**
         * The tags associated with the copied model.
         */
        public var targetModelTags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.GetModelCopyJobResponse) : this() {
            this.creationTime = x.creationTime
            this.failureMessage = x.failureMessage
            this.jobArn = x.jobArn
            this.sourceAccountId = x.sourceAccountId
            this.sourceModelArn = x.sourceModelArn
            this.sourceModelName = x.sourceModelName
            this.status = x.status
            this.targetModelArn = x.targetModelArn
            this.targetModelKmsKeyArn = x.targetModelKmsKeyArn
            this.targetModelName = x.targetModelName
            this.targetModelTags = x.targetModelTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.GetModelCopyJobResponse = GetModelCopyJobResponse(this)

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (jobArn == null) jobArn = ""
            if (sourceAccountId == null) sourceAccountId = ""
            if (sourceModelArn == null) sourceModelArn = ""
            if (status == null) status = ModelCopyJobStatus.SdkUnknown("no value provided")
            if (targetModelArn == null) targetModelArn = ""
            return this
        }
    }
}
