// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetGuardrailResponse private constructor(builder: Builder) {
    /**
     * The message that the guardrail returns when it blocks a prompt.
     */
    public val blockedInputMessaging: kotlin.String = requireNotNull(builder.blockedInputMessaging) { "A non-null value must be provided for blockedInputMessaging" }
    /**
     * The message that the guardrail returns when it blocks a model response.
     */
    public val blockedOutputsMessaging: kotlin.String = requireNotNull(builder.blockedOutputsMessaging) { "A non-null value must be provided for blockedOutputsMessaging" }
    /**
     * The content policy that was configured for the guardrail.
     */
    public val contentPolicy: aws.sdk.kotlin.services.bedrock.model.GuardrailContentPolicy? = builder.contentPolicy
    /**
     * The contextual grounding policy used in the guardrail.
     */
    public val contextualGroundingPolicy: aws.sdk.kotlin.services.bedrock.model.GuardrailContextualGroundingPolicy? = builder.contextualGroundingPolicy
    /**
     * The date and time at which the guardrail was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The description of the guardrail.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Appears if the `status` of the guardrail is `FAILED`. A list of recommendations to carry out before retrying the request.
     */
    public val failureRecommendations: List<String>? = builder.failureRecommendations
    /**
     * The ARN of the guardrail.
     */
    public val guardrailArn: kotlin.String = requireNotNull(builder.guardrailArn) { "A non-null value must be provided for guardrailArn" }
    /**
     * The unique identifier of the guardrail.
     */
    public val guardrailId: kotlin.String = requireNotNull(builder.guardrailId) { "A non-null value must be provided for guardrailId" }
    /**
     * The ARN of the KMS key that encrypts the guardrail.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The name of the guardrail.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The sensitive information policy that was configured for the guardrail.
     */
    public val sensitiveInformationPolicy: aws.sdk.kotlin.services.bedrock.model.GuardrailSensitiveInformationPolicy? = builder.sensitiveInformationPolicy
    /**
     * The status of the guardrail.
     */
    public val status: aws.sdk.kotlin.services.bedrock.model.GuardrailStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Appears if the `status` is `FAILED`. A list of reasons for why the guardrail failed to be created, updated, versioned, or deleted.
     */
    public val statusReasons: List<String>? = builder.statusReasons
    /**
     * The topic policy that was configured for the guardrail.
     */
    public val topicPolicy: aws.sdk.kotlin.services.bedrock.model.GuardrailTopicPolicy? = builder.topicPolicy
    /**
     * The date and time at which the guardrail was updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }
    /**
     * The version of the guardrail.
     */
    public val version: kotlin.String = requireNotNull(builder.version) { "A non-null value must be provided for version" }
    /**
     * The word policy that was configured for the guardrail.
     */
    public val wordPolicy: aws.sdk.kotlin.services.bedrock.model.GuardrailWordPolicy? = builder.wordPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.GetGuardrailResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetGuardrailResponse(")
        append("blockedInputMessaging=*** Sensitive Data Redacted ***,")
        append("blockedOutputsMessaging=*** Sensitive Data Redacted ***,")
        append("contentPolicy=$contentPolicy,")
        append("contextualGroundingPolicy=$contextualGroundingPolicy,")
        append("createdAt=$createdAt,")
        append("description=*** Sensitive Data Redacted ***,")
        append("failureRecommendations=*** Sensitive Data Redacted ***,")
        append("guardrailArn=$guardrailArn,")
        append("guardrailId=$guardrailId,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("name=*** Sensitive Data Redacted ***,")
        append("sensitiveInformationPolicy=$sensitiveInformationPolicy,")
        append("status=$status,")
        append("statusReasons=*** Sensitive Data Redacted ***,")
        append("topicPolicy=$topicPolicy,")
        append("updatedAt=$updatedAt,")
        append("version=$version,")
        append("wordPolicy=$wordPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockedInputMessaging.hashCode()
        result = 31 * result + (blockedOutputsMessaging.hashCode())
        result = 31 * result + (contentPolicy?.hashCode() ?: 0)
        result = 31 * result + (contextualGroundingPolicy?.hashCode() ?: 0)
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (failureRecommendations?.hashCode() ?: 0)
        result = 31 * result + (guardrailArn.hashCode())
        result = 31 * result + (guardrailId.hashCode())
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (sensitiveInformationPolicy?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusReasons?.hashCode() ?: 0)
        result = 31 * result + (topicPolicy?.hashCode() ?: 0)
        result = 31 * result + (updatedAt.hashCode())
        result = 31 * result + (version.hashCode())
        result = 31 * result + (wordPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetGuardrailResponse

        if (blockedInputMessaging != other.blockedInputMessaging) return false
        if (blockedOutputsMessaging != other.blockedOutputsMessaging) return false
        if (contentPolicy != other.contentPolicy) return false
        if (contextualGroundingPolicy != other.contextualGroundingPolicy) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (failureRecommendations != other.failureRecommendations) return false
        if (guardrailArn != other.guardrailArn) return false
        if (guardrailId != other.guardrailId) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (name != other.name) return false
        if (sensitiveInformationPolicy != other.sensitiveInformationPolicy) return false
        if (status != other.status) return false
        if (statusReasons != other.statusReasons) return false
        if (topicPolicy != other.topicPolicy) return false
        if (updatedAt != other.updatedAt) return false
        if (version != other.version) return false
        if (wordPolicy != other.wordPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.GetGuardrailResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The message that the guardrail returns when it blocks a prompt.
         */
        public var blockedInputMessaging: kotlin.String? = null
        /**
         * The message that the guardrail returns when it blocks a model response.
         */
        public var blockedOutputsMessaging: kotlin.String? = null
        /**
         * The content policy that was configured for the guardrail.
         */
        public var contentPolicy: aws.sdk.kotlin.services.bedrock.model.GuardrailContentPolicy? = null
        /**
         * The contextual grounding policy used in the guardrail.
         */
        public var contextualGroundingPolicy: aws.sdk.kotlin.services.bedrock.model.GuardrailContextualGroundingPolicy? = null
        /**
         * The date and time at which the guardrail was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the guardrail.
         */
        public var description: kotlin.String? = null
        /**
         * Appears if the `status` of the guardrail is `FAILED`. A list of recommendations to carry out before retrying the request.
         */
        public var failureRecommendations: List<String>? = null
        /**
         * The ARN of the guardrail.
         */
        public var guardrailArn: kotlin.String? = null
        /**
         * The unique identifier of the guardrail.
         */
        public var guardrailId: kotlin.String? = null
        /**
         * The ARN of the KMS key that encrypts the guardrail.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The name of the guardrail.
         */
        public var name: kotlin.String? = null
        /**
         * The sensitive information policy that was configured for the guardrail.
         */
        public var sensitiveInformationPolicy: aws.sdk.kotlin.services.bedrock.model.GuardrailSensitiveInformationPolicy? = null
        /**
         * The status of the guardrail.
         */
        public var status: aws.sdk.kotlin.services.bedrock.model.GuardrailStatus? = null
        /**
         * Appears if the `status` is `FAILED`. A list of reasons for why the guardrail failed to be created, updated, versioned, or deleted.
         */
        public var statusReasons: List<String>? = null
        /**
         * The topic policy that was configured for the guardrail.
         */
        public var topicPolicy: aws.sdk.kotlin.services.bedrock.model.GuardrailTopicPolicy? = null
        /**
         * The date and time at which the guardrail was updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The version of the guardrail.
         */
        public var version: kotlin.String? = null
        /**
         * The word policy that was configured for the guardrail.
         */
        public var wordPolicy: aws.sdk.kotlin.services.bedrock.model.GuardrailWordPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.GetGuardrailResponse) : this() {
            this.blockedInputMessaging = x.blockedInputMessaging
            this.blockedOutputsMessaging = x.blockedOutputsMessaging
            this.contentPolicy = x.contentPolicy
            this.contextualGroundingPolicy = x.contextualGroundingPolicy
            this.createdAt = x.createdAt
            this.description = x.description
            this.failureRecommendations = x.failureRecommendations
            this.guardrailArn = x.guardrailArn
            this.guardrailId = x.guardrailId
            this.kmsKeyArn = x.kmsKeyArn
            this.name = x.name
            this.sensitiveInformationPolicy = x.sensitiveInformationPolicy
            this.status = x.status
            this.statusReasons = x.statusReasons
            this.topicPolicy = x.topicPolicy
            this.updatedAt = x.updatedAt
            this.version = x.version
            this.wordPolicy = x.wordPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.GetGuardrailResponse = GetGuardrailResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.GuardrailContentPolicy] inside the given [block]
         */
        public fun contentPolicy(block: aws.sdk.kotlin.services.bedrock.model.GuardrailContentPolicy.Builder.() -> kotlin.Unit) {
            this.contentPolicy = aws.sdk.kotlin.services.bedrock.model.GuardrailContentPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.GuardrailContextualGroundingPolicy] inside the given [block]
         */
        public fun contextualGroundingPolicy(block: aws.sdk.kotlin.services.bedrock.model.GuardrailContextualGroundingPolicy.Builder.() -> kotlin.Unit) {
            this.contextualGroundingPolicy = aws.sdk.kotlin.services.bedrock.model.GuardrailContextualGroundingPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.GuardrailSensitiveInformationPolicy] inside the given [block]
         */
        public fun sensitiveInformationPolicy(block: aws.sdk.kotlin.services.bedrock.model.GuardrailSensitiveInformationPolicy.Builder.() -> kotlin.Unit) {
            this.sensitiveInformationPolicy = aws.sdk.kotlin.services.bedrock.model.GuardrailSensitiveInformationPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.GuardrailTopicPolicy] inside the given [block]
         */
        public fun topicPolicy(block: aws.sdk.kotlin.services.bedrock.model.GuardrailTopicPolicy.Builder.() -> kotlin.Unit) {
            this.topicPolicy = aws.sdk.kotlin.services.bedrock.model.GuardrailTopicPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.GuardrailWordPolicy] inside the given [block]
         */
        public fun wordPolicy(block: aws.sdk.kotlin.services.bedrock.model.GuardrailWordPolicy.Builder.() -> kotlin.Unit) {
            this.wordPolicy = aws.sdk.kotlin.services.bedrock.model.GuardrailWordPolicy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (blockedInputMessaging == null) blockedInputMessaging = ""
            if (blockedOutputsMessaging == null) blockedOutputsMessaging = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (guardrailArn == null) guardrailArn = ""
            if (guardrailId == null) guardrailId = ""
            if (name == null) name = ""
            if (status == null) status = GuardrailStatus.SdkUnknown("no value provided")
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            if (version == null) version = ""
            return this
        }
    }
}
