// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetEvaluationJobResponse private constructor(builder: Builder) {
    /**
     * When the model evaluation job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The Amazon Resource Name (ARN) of the customer managed key specified when the model evaluation job was created.
     */
    public val customerEncryptionKeyId: kotlin.String? = builder.customerEncryptionKeyId
    /**
     * Contains details about the type of model evaluation job, the metrics used, the task type selected, the datasets used, and any custom metrics you defined.
     */
    public val evaluationConfig: aws.sdk.kotlin.services.bedrock.model.EvaluationConfig? = builder.evaluationConfig
    /**
     * An array of strings the specify why the model evaluation job has failed.
     */
    public val failureMessages: List<String>? = builder.failureMessages
    /**
     * Details about the models you specified in your model evaluation job.
     */
    public val inferenceConfig: aws.sdk.kotlin.services.bedrock.model.EvaluationInferenceConfig? = builder.inferenceConfig
    /**
     * The Amazon Resource Name (ARN) of the model evaluation job.
     */
    public val jobArn: kotlin.String = requireNotNull(builder.jobArn) { "A non-null value must be provided for jobArn" }
    /**
     * The description of the model evaluation job.
     */
    public val jobDescription: kotlin.String? = builder.jobDescription
    /**
     * The name of the model evaluation job.
     */
    public val jobName: kotlin.String = requireNotNull(builder.jobName) { "A non-null value must be provided for jobName" }
    /**
     * The type of model evaluation job.
     */
    public val jobType: aws.sdk.kotlin.services.bedrock.model.EvaluationJobType = requireNotNull(builder.jobType) { "A non-null value must be provided for jobType" }
    /**
     * When the model evaluation job was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Amazon S3 location for where output data is saved.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.bedrock.model.EvaluationOutputDataConfig? = builder.outputDataConfig
    /**
     * The Amazon Resource Name (ARN) of the IAM service role used in the model evaluation job.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The status of the model evaluation job.
     */
    public val status: aws.sdk.kotlin.services.bedrock.model.EvaluationJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.GetEvaluationJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetEvaluationJobResponse(")
        append("creationTime=$creationTime,")
        append("customerEncryptionKeyId=$customerEncryptionKeyId,")
        append("evaluationConfig=$evaluationConfig,")
        append("failureMessages=$failureMessages,")
        append("inferenceConfig=$inferenceConfig,")
        append("jobArn=$jobArn,")
        append("jobDescription=*** Sensitive Data Redacted ***,")
        append("jobName=$jobName,")
        append("jobType=$jobType,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("outputDataConfig=$outputDataConfig,")
        append("roleArn=$roleArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (customerEncryptionKeyId?.hashCode() ?: 0)
        result = 31 * result + (evaluationConfig?.hashCode() ?: 0)
        result = 31 * result + (failureMessages?.hashCode() ?: 0)
        result = 31 * result + (inferenceConfig?.hashCode() ?: 0)
        result = 31 * result + (jobArn.hashCode())
        result = 31 * result + (jobDescription?.hashCode() ?: 0)
        result = 31 * result + (jobName.hashCode())
        result = 31 * result + (jobType.hashCode())
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetEvaluationJobResponse

        if (creationTime != other.creationTime) return false
        if (customerEncryptionKeyId != other.customerEncryptionKeyId) return false
        if (evaluationConfig != other.evaluationConfig) return false
        if (failureMessages != other.failureMessages) return false
        if (inferenceConfig != other.inferenceConfig) return false
        if (jobArn != other.jobArn) return false
        if (jobDescription != other.jobDescription) return false
        if (jobName != other.jobName) return false
        if (jobType != other.jobType) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.GetEvaluationJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the model evaluation job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the customer managed key specified when the model evaluation job was created.
         */
        public var customerEncryptionKeyId: kotlin.String? = null
        /**
         * Contains details about the type of model evaluation job, the metrics used, the task type selected, the datasets used, and any custom metrics you defined.
         */
        public var evaluationConfig: aws.sdk.kotlin.services.bedrock.model.EvaluationConfig? = null
        /**
         * An array of strings the specify why the model evaluation job has failed.
         */
        public var failureMessages: List<String>? = null
        /**
         * Details about the models you specified in your model evaluation job.
         */
        public var inferenceConfig: aws.sdk.kotlin.services.bedrock.model.EvaluationInferenceConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the model evaluation job.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The description of the model evaluation job.
         */
        public var jobDescription: kotlin.String? = null
        /**
         * The name of the model evaluation job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The type of model evaluation job.
         */
        public var jobType: aws.sdk.kotlin.services.bedrock.model.EvaluationJobType? = null
        /**
         * When the model evaluation job was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Amazon S3 location for where output data is saved.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.bedrock.model.EvaluationOutputDataConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM service role used in the model evaluation job.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The status of the model evaluation job.
         */
        public var status: aws.sdk.kotlin.services.bedrock.model.EvaluationJobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.GetEvaluationJobResponse) : this() {
            this.creationTime = x.creationTime
            this.customerEncryptionKeyId = x.customerEncryptionKeyId
            this.evaluationConfig = x.evaluationConfig
            this.failureMessages = x.failureMessages
            this.inferenceConfig = x.inferenceConfig
            this.jobArn = x.jobArn
            this.jobDescription = x.jobDescription
            this.jobName = x.jobName
            this.jobType = x.jobType
            this.lastModifiedTime = x.lastModifiedTime
            this.outputDataConfig = x.outputDataConfig
            this.roleArn = x.roleArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.GetEvaluationJobResponse = GetEvaluationJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.EvaluationOutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.bedrock.model.EvaluationOutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.bedrock.model.EvaluationOutputDataConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (jobArn == null) jobArn = ""
            if (jobName == null) jobName = ""
            if (jobType == null) jobType = EvaluationJobType.SdkUnknown("no value provided")
            if (roleArn == null) roleArn = ""
            if (status == null) status = EvaluationJobStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
