// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetCustomModelResponse private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the base model.
     */
    public val baseModelArn: kotlin.String = requireNotNull(builder.baseModelArn) { "A non-null value must be provided for baseModelArn" }
    /**
     * Creation time of the model.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The type of model customization.
     */
    public val customizationType: aws.sdk.kotlin.services.bedrock.model.CustomizationType? = builder.customizationType
    /**
     * Hyperparameter values associated with this model. For details on the format for different models, see [Custom model hyperparameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html).
     */
    public val hyperParameters: Map<String, String>? = builder.hyperParameters
    /**
     * Job Amazon Resource Name (ARN) associated with this model.
     */
    public val jobArn: kotlin.String = requireNotNull(builder.jobArn) { "A non-null value must be provided for jobArn" }
    /**
     * Job name associated with this model.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * Amazon Resource Name (ARN) associated with this model.
     */
    public val modelArn: kotlin.String = requireNotNull(builder.modelArn) { "A non-null value must be provided for modelArn" }
    /**
     * The custom model is encrypted at rest using this key.
     */
    public val modelKmsKeyArn: kotlin.String? = builder.modelKmsKeyArn
    /**
     * Model name associated with this model.
     */
    public val modelName: kotlin.String = requireNotNull(builder.modelName) { "A non-null value must be provided for modelName" }
    /**
     * Output data configuration associated with this custom model.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.bedrock.model.OutputDataConfig? = builder.outputDataConfig
    /**
     * Contains information about the training dataset.
     */
    public val trainingDataConfig: aws.sdk.kotlin.services.bedrock.model.TrainingDataConfig? = builder.trainingDataConfig
    /**
     * Contains training metrics from the job creation.
     */
    public val trainingMetrics: aws.sdk.kotlin.services.bedrock.model.TrainingMetrics? = builder.trainingMetrics
    /**
     * Contains information about the validation dataset.
     */
    public val validationDataConfig: aws.sdk.kotlin.services.bedrock.model.ValidationDataConfig? = builder.validationDataConfig
    /**
     * The validation metrics from the job creation.
     */
    public val validationMetrics: List<ValidatorMetric>? = builder.validationMetrics

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.GetCustomModelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetCustomModelResponse(")
        append("baseModelArn=$baseModelArn,")
        append("creationTime=$creationTime,")
        append("customizationType=$customizationType,")
        append("hyperParameters=$hyperParameters,")
        append("jobArn=$jobArn,")
        append("jobName=$jobName,")
        append("modelArn=$modelArn,")
        append("modelKmsKeyArn=$modelKmsKeyArn,")
        append("modelName=$modelName,")
        append("outputDataConfig=$outputDataConfig,")
        append("trainingDataConfig=$trainingDataConfig,")
        append("trainingMetrics=$trainingMetrics,")
        append("validationDataConfig=$validationDataConfig,")
        append("validationMetrics=$validationMetrics")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseModelArn.hashCode()
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (customizationType?.hashCode() ?: 0)
        result = 31 * result + (hyperParameters?.hashCode() ?: 0)
        result = 31 * result + (jobArn.hashCode())
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (modelArn.hashCode())
        result = 31 * result + (modelKmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (modelName.hashCode())
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (trainingDataConfig?.hashCode() ?: 0)
        result = 31 * result + (trainingMetrics?.hashCode() ?: 0)
        result = 31 * result + (validationDataConfig?.hashCode() ?: 0)
        result = 31 * result + (validationMetrics?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetCustomModelResponse

        if (baseModelArn != other.baseModelArn) return false
        if (creationTime != other.creationTime) return false
        if (customizationType != other.customizationType) return false
        if (hyperParameters != other.hyperParameters) return false
        if (jobArn != other.jobArn) return false
        if (jobName != other.jobName) return false
        if (modelArn != other.modelArn) return false
        if (modelKmsKeyArn != other.modelKmsKeyArn) return false
        if (modelName != other.modelName) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (trainingDataConfig != other.trainingDataConfig) return false
        if (trainingMetrics != other.trainingMetrics) return false
        if (validationDataConfig != other.validationDataConfig) return false
        if (validationMetrics != other.validationMetrics) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.GetCustomModelResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the base model.
         */
        public var baseModelArn: kotlin.String? = null
        /**
         * Creation time of the model.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of model customization.
         */
        public var customizationType: aws.sdk.kotlin.services.bedrock.model.CustomizationType? = null
        /**
         * Hyperparameter values associated with this model. For details on the format for different models, see [Custom model hyperparameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html).
         */
        public var hyperParameters: Map<String, String>? = null
        /**
         * Job Amazon Resource Name (ARN) associated with this model.
         */
        public var jobArn: kotlin.String? = null
        /**
         * Job name associated with this model.
         */
        public var jobName: kotlin.String? = null
        /**
         * Amazon Resource Name (ARN) associated with this model.
         */
        public var modelArn: kotlin.String? = null
        /**
         * The custom model is encrypted at rest using this key.
         */
        public var modelKmsKeyArn: kotlin.String? = null
        /**
         * Model name associated with this model.
         */
        public var modelName: kotlin.String? = null
        /**
         * Output data configuration associated with this custom model.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.bedrock.model.OutputDataConfig? = null
        /**
         * Contains information about the training dataset.
         */
        public var trainingDataConfig: aws.sdk.kotlin.services.bedrock.model.TrainingDataConfig? = null
        /**
         * Contains training metrics from the job creation.
         */
        public var trainingMetrics: aws.sdk.kotlin.services.bedrock.model.TrainingMetrics? = null
        /**
         * Contains information about the validation dataset.
         */
        public var validationDataConfig: aws.sdk.kotlin.services.bedrock.model.ValidationDataConfig? = null
        /**
         * The validation metrics from the job creation.
         */
        public var validationMetrics: List<ValidatorMetric>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.GetCustomModelResponse) : this() {
            this.baseModelArn = x.baseModelArn
            this.creationTime = x.creationTime
            this.customizationType = x.customizationType
            this.hyperParameters = x.hyperParameters
            this.jobArn = x.jobArn
            this.jobName = x.jobName
            this.modelArn = x.modelArn
            this.modelKmsKeyArn = x.modelKmsKeyArn
            this.modelName = x.modelName
            this.outputDataConfig = x.outputDataConfig
            this.trainingDataConfig = x.trainingDataConfig
            this.trainingMetrics = x.trainingMetrics
            this.validationDataConfig = x.validationDataConfig
            this.validationMetrics = x.validationMetrics
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.GetCustomModelResponse = GetCustomModelResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.OutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.bedrock.model.OutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.bedrock.model.OutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.TrainingDataConfig] inside the given [block]
         */
        public fun trainingDataConfig(block: aws.sdk.kotlin.services.bedrock.model.TrainingDataConfig.Builder.() -> kotlin.Unit) {
            this.trainingDataConfig = aws.sdk.kotlin.services.bedrock.model.TrainingDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.TrainingMetrics] inside the given [block]
         */
        public fun trainingMetrics(block: aws.sdk.kotlin.services.bedrock.model.TrainingMetrics.Builder.() -> kotlin.Unit) {
            this.trainingMetrics = aws.sdk.kotlin.services.bedrock.model.TrainingMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.ValidationDataConfig] inside the given [block]
         */
        public fun validationDataConfig(block: aws.sdk.kotlin.services.bedrock.model.ValidationDataConfig.Builder.() -> kotlin.Unit) {
            this.validationDataConfig = aws.sdk.kotlin.services.bedrock.model.ValidationDataConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (baseModelArn == null) baseModelArn = ""
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (jobArn == null) jobArn = ""
            if (modelArn == null) modelArn = ""
            if (modelName == null) modelName = ""
            return this
        }
    }
}
