// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of the model evaluation job.
 */
public class EvaluationSummary private constructor(builder: Builder) {
    /**
     * When the model evaluation job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * What task type was used in the model evaluation job.
     */
    public val evaluationTaskTypes: List<EvaluationTaskType> = requireNotNull(builder.evaluationTaskTypes) { "A non-null value must be provided for evaluationTaskTypes" }
    /**
     * The Amazon Resource Name (ARN) of the model evaluation job.
     */
    public val jobArn: kotlin.String = requireNotNull(builder.jobArn) { "A non-null value must be provided for jobArn" }
    /**
     * The name of the model evaluation job.
     */
    public val jobName: kotlin.String = requireNotNull(builder.jobName) { "A non-null value must be provided for jobName" }
    /**
     * The type, either human or automatic, of model evaluation job.
     */
    public val jobType: aws.sdk.kotlin.services.bedrock.model.EvaluationJobType = requireNotNull(builder.jobType) { "A non-null value must be provided for jobType" }
    /**
     * The Amazon Resource Names (ARNs) of the model(s) used in the model evaluation job.
     */
    public val modelIdentifiers: List<String> = requireNotNull(builder.modelIdentifiers) { "A non-null value must be provided for modelIdentifiers" }
    /**
     * The current status of the model evaluation job.
     */
    public val status: aws.sdk.kotlin.services.bedrock.model.EvaluationJobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.EvaluationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvaluationSummary(")
        append("creationTime=$creationTime,")
        append("evaluationTaskTypes=$evaluationTaskTypes,")
        append("jobArn=$jobArn,")
        append("jobName=$jobName,")
        append("jobType=$jobType,")
        append("modelIdentifiers=$modelIdentifiers,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (evaluationTaskTypes.hashCode())
        result = 31 * result + (jobArn.hashCode())
        result = 31 * result + (jobName.hashCode())
        result = 31 * result + (jobType.hashCode())
        result = 31 * result + (modelIdentifiers.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvaluationSummary

        if (creationTime != other.creationTime) return false
        if (evaluationTaskTypes != other.evaluationTaskTypes) return false
        if (jobArn != other.jobArn) return false
        if (jobName != other.jobName) return false
        if (jobType != other.jobType) return false
        if (modelIdentifiers != other.modelIdentifiers) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.EvaluationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the model evaluation job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * What task type was used in the model evaluation job.
         */
        public var evaluationTaskTypes: List<EvaluationTaskType>? = null
        /**
         * The Amazon Resource Name (ARN) of the model evaluation job.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The name of the model evaluation job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The type, either human or automatic, of model evaluation job.
         */
        public var jobType: aws.sdk.kotlin.services.bedrock.model.EvaluationJobType? = null
        /**
         * The Amazon Resource Names (ARNs) of the model(s) used in the model evaluation job.
         */
        public var modelIdentifiers: List<String>? = null
        /**
         * The current status of the model evaluation job.
         */
        public var status: aws.sdk.kotlin.services.bedrock.model.EvaluationJobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.EvaluationSummary) : this() {
            this.creationTime = x.creationTime
            this.evaluationTaskTypes = x.evaluationTaskTypes
            this.jobArn = x.jobArn
            this.jobName = x.jobName
            this.jobType = x.jobType
            this.modelIdentifiers = x.modelIdentifiers
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.EvaluationSummary = EvaluationSummary(this)

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (evaluationTaskTypes == null) evaluationTaskTypes = emptyList()
            if (jobArn == null) jobArn = ""
            if (jobName == null) jobName = ""
            if (jobType == null) jobType = EvaluationJobType.SdkUnknown("no value provided")
            if (modelIdentifiers == null) modelIdentifiers = emptyList()
            if (status == null) status = EvaluationJobStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
