// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines the built-in prompt datasets, built-in metric names and custom metric names, and the task type.
 */
public class EvaluationDatasetMetricConfig private constructor(builder: Builder) {
    /**
     * Specifies the prompt dataset.
     */
    public val dataset: aws.sdk.kotlin.services.bedrock.model.EvaluationDataset? = builder.dataset
    /**
     * The names of the metrics used. For automated model evaluation jobs valid values are `"Builtin.Accuracy"`, `"Builtin.Robustness"`, and `"Builtin.Toxicity"`. In human-based model evaluation jobs the array of strings must match the `name` parameter specified in `HumanEvaluationCustomMetric`.
     */
    public val metricNames: List<String> = requireNotNull(builder.metricNames) { "A non-null value must be provided for metricNames" }
    /**
     * The task type you want the model to carry out.
     */
    public val taskType: aws.sdk.kotlin.services.bedrock.model.EvaluationTaskType = requireNotNull(builder.taskType) { "A non-null value must be provided for taskType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.EvaluationDatasetMetricConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvaluationDatasetMetricConfig(")
        append("dataset=$dataset,")
        append("metricNames=*** Sensitive Data Redacted ***,")
        append("taskType=$taskType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataset?.hashCode() ?: 0
        result = 31 * result + (metricNames.hashCode())
        result = 31 * result + (taskType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvaluationDatasetMetricConfig

        if (dataset != other.dataset) return false
        if (metricNames != other.metricNames) return false
        if (taskType != other.taskType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.EvaluationDatasetMetricConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the prompt dataset.
         */
        public var dataset: aws.sdk.kotlin.services.bedrock.model.EvaluationDataset? = null
        /**
         * The names of the metrics used. For automated model evaluation jobs valid values are `"Builtin.Accuracy"`, `"Builtin.Robustness"`, and `"Builtin.Toxicity"`. In human-based model evaluation jobs the array of strings must match the `name` parameter specified in `HumanEvaluationCustomMetric`.
         */
        public var metricNames: List<String>? = null
        /**
         * The task type you want the model to carry out.
         */
        public var taskType: aws.sdk.kotlin.services.bedrock.model.EvaluationTaskType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.EvaluationDatasetMetricConfig) : this() {
            this.dataset = x.dataset
            this.metricNames = x.metricNames
            this.taskType = x.taskType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.EvaluationDatasetMetricConfig = EvaluationDatasetMetricConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.bedrock.model.EvaluationDataset] inside the given [block]
         */
        public fun dataset(block: aws.sdk.kotlin.services.bedrock.model.EvaluationDataset.Builder.() -> kotlin.Unit) {
            this.dataset = aws.sdk.kotlin.services.bedrock.model.EvaluationDataset.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (metricNames == null) metricNames = emptyList()
            if (taskType == null) taskType = EvaluationTaskType.SdkUnknown("no value provided")
            return this
        }
    }
}
