// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Used to specify the name of a built-in prompt dataset and optionally, the Amazon S3 bucket where a custom prompt dataset is saved.
 */
public class EvaluationDataset private constructor(builder: Builder) {
    /**
     * For custom prompt datasets, you must specify the location in Amazon S3 where the prompt dataset is saved.
     */
    public val datasetLocation: aws.sdk.kotlin.services.bedrock.model.EvaluationDatasetLocation? = builder.datasetLocation
    /**
     * Used to specify supported built-in prompt datasets. Valid values are `Builtin.Bold`, `Builtin.BoolQ`, `Builtin.NaturalQuestions`, `Builtin.Gigaword`, `Builtin.RealToxicityPrompts`, `Builtin.TriviaQA`, `Builtin.T-Rex`, `Builtin.WomensEcommerceClothingReviews` and `Builtin.Wikitext2`.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.EvaluationDataset = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvaluationDataset(")
        append("datasetLocation=$datasetLocation,")
        append("name=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = datasetLocation?.hashCode() ?: 0
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvaluationDataset

        if (datasetLocation != other.datasetLocation) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.EvaluationDataset = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * For custom prompt datasets, you must specify the location in Amazon S3 where the prompt dataset is saved.
         */
        public var datasetLocation: aws.sdk.kotlin.services.bedrock.model.EvaluationDatasetLocation? = null
        /**
         * Used to specify supported built-in prompt datasets. Valid values are `Builtin.Bold`, `Builtin.BoolQ`, `Builtin.NaturalQuestions`, `Builtin.Gigaword`, `Builtin.RealToxicityPrompts`, `Builtin.TriviaQA`, `Builtin.T-Rex`, `Builtin.WomensEcommerceClothingReviews` and `Builtin.Wikitext2`.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.EvaluationDataset) : this() {
            this.datasetLocation = x.datasetLocation
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.EvaluationDataset = EvaluationDataset(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
