// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrock.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the ARN of the Amazon Bedrock model or [inference profile](https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html) specified in your model evaluation job. Each Amazon Bedrock model supports different `inferenceParams`. To learn more about supported inference parameters for Amazon Bedrock models, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
 *
 * The `inferenceParams` are specified using JSON. To successfully insert JSON as string make sure that all quotations are properly escaped. For example, `"temperature":"0.25"` key value pair would need to be formatted as `\"temperature\":\"0.25\"` to successfully accepted in the request.
 */
public class EvaluationBedrockModel private constructor(builder: Builder) {
    /**
     * Each Amazon Bedrock support different inference parameters that change how the model behaves during inference.
     */
    public val inferenceParams: kotlin.String = requireNotNull(builder.inferenceParams) { "A non-null value must be provided for inferenceParams" }
    /**
     * The ARN of the Amazon Bedrock model or inference profile specified.
     */
    public val modelIdentifier: kotlin.String = requireNotNull(builder.modelIdentifier) { "A non-null value must be provided for modelIdentifier" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrock.model.EvaluationBedrockModel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvaluationBedrockModel(")
        append("inferenceParams=*** Sensitive Data Redacted ***,")
        append("modelIdentifier=$modelIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = inferenceParams.hashCode()
        result = 31 * result + (modelIdentifier.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvaluationBedrockModel

        if (inferenceParams != other.inferenceParams) return false
        if (modelIdentifier != other.modelIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrock.model.EvaluationBedrockModel = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Each Amazon Bedrock support different inference parameters that change how the model behaves during inference.
         */
        public var inferenceParams: kotlin.String? = null
        /**
         * The ARN of the Amazon Bedrock model or inference profile specified.
         */
        public var modelIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrock.model.EvaluationBedrockModel) : this() {
            this.inferenceParams = x.inferenceParams
            this.modelIdentifier = x.modelIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrock.model.EvaluationBedrockModel = EvaluationBedrockModel(this)

        internal fun correctErrors(): Builder {
            if (inferenceParams == null) inferenceParams = ""
            if (modelIdentifier == null) modelIdentifier = ""
            return this
        }
    }
}
